# RCHARDWEB - Soluções Tecnológicas

Um site moderno e responsivo para soluções tecnológicas, desenvolvido com HTML, CSS e JavaScript.

## 🌟 Características

- **Design Moderno e Responsivo**: Layout totalmente responsivo que se adapta a qualquer dispositivo
- **Animações e Efeitos**: Transições suaves, animações ao rolar e efeitos visuais atraentes
- **Navegação Intuitiva**: Menu responsivo com navegação por scroll
- **Seções Completas**:
  - Header com navegação e busca
  - Hero section com call-to-action
  - Sobre a empresa - apresentação da missão e valores
  - Estatísticas em destaque
  - Categorias de serviços tecnológicos
  - Processo passo a passo
  - Depoimentos de clientes
  - Página de contato com informações e formulário
  - Página "Sobre" detalhada com história, missão, visão e valores
  - Call-to-action final
  - Footer completo com links e newsletter

## 🛠️ Tecnologias Utilizadas

- **HTML5**: Estrutura semântica e moderna
- **CSS3**: Flexbox, Grid, animações e transições
- **JavaScript**: Interatividade e funcionalidades dinâmicas
- **Font Awesome**: Ícones vetoriais
- **Google Fonts**: Tipografia personalizada

## 📁 Estrutura do Projeto

```
projeto123/
├── index.html
├── categorias.html
├── sobre.html
├── contato.html
├── styles.css
├── script.js
└── README.md
```

## 🚀 Como Executar

1. Clone ou baixe este repositório
2. Abra o arquivo `index.html` no seu navegador preferido
3. Navegue pelas diferentes páginas usando o menu de navegação

Não é necessário instalar dependências ou configurar servidores - o site funciona diretamente no navegador!

## 🎨 Funcionalidades Destacadas

### Design e UI/UX
- Design moderno com gradientes e sombras sutis
- Tipografia otimizada com Google Fonts
- Cores harmoniosas com destaque para roxo (#8a2be2)
- Ícones intuitivos do Font Awesome
- Botões com efeitos hover e transições suaves

### Responsividade
- Layout adaptável para mobile, tablet e desktop
- Menu hambúrguer para dispositivos móveis
- Grids responsivos com CSS Grid e Flexbox
- Media queries otimizadas para diferentes tamanhos de tela

### Interatividade
- Animações ao rolar a página (Intersection Observer)
- Efeitos parallax no hero banner
- Notificações toast para feedback do usuário
- Validação de formulários
- Navegação suave entre seções
- Destacamento automático da seção ativa no menu

### Componentes Especiais
- Cards de serviços com efeitos hover dinâmicos
- Sistema de estatísticas em destaque
- Seção de depoimentos com design elegante
- Footer completo com newsletter, links e informações de contato

## 📱 Compatibilidade

O site é compatível com todos os navegadores modernos:
- Chrome (versão mais recente)
- Firefox (versão mais recente)
- Safari (versão mais recente)
- Edge (versão mais recente)

## 📝 Personalização

Para personalizar o conteúdo:
1. Edite o `index.html` para modificar textos, títulos e estrutura
2. Ajuste o `categorias.html` para modificar os serviços oferecidos
3. Atualize o `sobre.html` para modificar informações da empresa
4. Atualize o `contato.html` para modificar informações de contato
5. Ajuste o `styles.css` para modificar cores, espaçamentos e estilos
6. Atualize o `script.js` para modificar interações e funcionalidades

## 🤝 Contribuição

Sinta-se à vontade para contribuir com melhorias:

1. Faça um fork do projeto
2. Crie uma branch para sua feature (`git checkout -b feature/AmazingFeature`)
3. Commit suas mudanças (`git commit -m 'Add some AmazingFeature'`)
4. Push para a branch (`git push origin feature/AmazingFeature`)
5. Abra um Pull Request

## 📄 Licença

Distribuído sob a licença MIT. Veja `LICENSE` para mais informações.

## 📧 Contato

Seu Nome - seu.email@example.com

Link do Projeto: [https://github.com/seu-usuario/reparaai](https://github.com/seu-usuario/reparaai)