<?php
include '../autentica.php';
include '../conexao.php';

header('Content-Type: application/json');

if ($usuario['tipo'] != 'admin') {
    echo json_encode(['status' => 'erro', 'msg' => 'Acesso negado']);
    exit;
}

if ($_POST['acao'] ?? '' !== 'cadastrar_usuario') {
    echo json_encode(['status' => 'erro', 'msg' => 'Ação inválida']);
    exit;
}

$nome = trim($_POST['nome'] ?? '');
$email = trim($_POST['email'] ?? '');
$tipo = trim($_POST['tipo'] ?? '');
$senha = $_POST['senha'] ?? '';

if (!$nome || !$email || !$tipo || !$senha) {
    echo json_encode(['status' => 'erro', 'msg' => 'Preencha todos os campos']);
    exit;
}

// Verifica se email já existe
$stmt = $pdo->prepare("SELECT COUNT(*) FROM usuarios WHERE email = ?");
$stmt->execute([$email]);
if ($stmt->fetchColumn() > 0) {
    echo json_encode(['status' => 'erro', 'msg' => 'Email já cadastrado']);
    exit;
}

$senha_hash = password_hash($senha, PASSWORD_DEFAULT);

$stmt = $pdo->prepare("INSERT INTO usuarios (nome, email, tipo, senha) VALUES (?, ?, ?, ?)");
$ok = $stmt->execute([$nome, $email, $tipo, $senha_hash]);

if ($ok) {
    echo json_encode(['status' => 'ok']);
} else {
    echo json_encode(['status' => 'erro', 'msg' => 'Erro ao cadastrar']);
}
