<?php
include('conexao.php');

$data_inicio = date('Y-m-01');
$data_fim = date('Y-m-t 23:59:59');

$sql = "SELECT 
          COUNT(*) AS total_entregas,
          COALESCE(SUM(taxa), 0) AS total_taxas
        FROM entregas
        WHERE status = 'ACEITA'
          AND criado_em BETWEEN :inicio AND :fim";

$stmt = $pdo->prepare($sql);
$stmt->execute([
    ':inicio' => $data_inicio,
    ':fim' => $data_fim
]);

$result = $stmt->fetch(PDO::FETCH_ASSOC);

$total_entregas = (int)($result['total_entregas'] ?? 0);
$total_taxas = (float)($result['total_taxas'] ?? 0);
$lucro = $total_entregas * 2; // ou outro cálculo

echo json_encode([
    'total_taxas' => number_format($total_taxas, 2, ',', '.'),
    'lucro' => number_format($lucro, 2, ',', '.')
]);
