<?php
// salvar_user.php
require_once 'conexao.php'; // Inclua seu arquivo de conexão com PDO

// Recebe os dados do formulário
$nome  = $_POST['nome']  ?? '';
$email = $_POST['email'] ?? '';
$tipo  = $_POST['tipo']  ?? '';
$senha = $_POST['senha'] ?? '';

// Validação simples
if (!$nome || !$email || !$tipo || !$senha) {
    echo 'Preencha todos os campos!';
    exit;
}

// Criptografa a senha
$senha_hash = password_hash($senha, PASSWORD_DEFAULT);

// Verifica se o email já está cadastrado
$verifica_email = $pdo->prepare("SELECT id FROM usuarios WHERE email = ?");
$verifica_email->execute([$email]);

if ($verifica_email->rowCount() > 0) {
    echo 'Este e-mail já está cadastrado!';
    exit;
}

// Verifica se o nome já está cadastrado
$verifica_nome = $pdo->prepare("SELECT id FROM usuarios WHERE nome = ?");
$verifica_nome->execute([$nome]);

if ($verifica_nome->rowCount() > 0) {
    echo 'Este nome já está cadastrado!';
    exit;
}

// Insere no banco de dados com status "Ativo"
$stmt = $pdo->prepare("INSERT INTO usuarios (nome, email, tipo, senha, status) VALUES (?, ?, ?, ?, 'ATIVO')");
$sucesso = $stmt->execute([$nome, $email, $tipo, $senha_hash]);

if ($sucesso) {
    echo 'Usuário cadastrado com sucesso!';
} else {
    echo 'Erro ao cadastrar usuário.';
}
