<?php
// salvar_taxas.php
require_once 'conexao.php'; // ajuste para seu arquivo de conexão PDO

header('Content-Type: application/json');

// Recebe dados do POST
$id_taxa = isset($_POST['id_taxa']) ? (int)$_POST['id_taxa'] : 0;
$estabelecimento_id = isset($_POST['estabelecimento_id']) ? (int)$_POST['estabelecimento_id'] : 0;
$nome_bairro = isset($_POST['nome_bairro']) ? trim($_POST['nome_bairro']) : '';
$taxa = isset($_POST['taxa']) ? floatval(str_replace(',', '.', $_POST['taxa'])) : 0;

if (!$estabelecimento_id || !$nome_bairro || $taxa < 0) {
    echo json_encode(['status' => 'error', 'msg' => 'Dados inválidos.']);
    exit;
}

try {
    // Confirma que estabelecimento existe e é do tipo restaurante
    $stmt = $pdo->prepare("SELECT id FROM usuarios WHERE id = :id AND tipo = 'restaurante'");
    $stmt->execute([':id' => $estabelecimento_id]);
    if (!$stmt->fetch()) {
        echo json_encode(['status' => 'error', 'msg' => 'Estabelecimento inválido.']);
        exit;
    }

    if ($id_taxa > 0) {
        // Atualiza taxa existente
        $sql = "UPDATE bairros_taxas SET estabelecimento_id = :estabelecimento_id, nome_bairro = :nome_bairro, taxa = :taxa WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':estabelecimento_id' => $estabelecimento_id,
            ':nome_bairro' => $nome_bairro,
            ':taxa' => $taxa,
            ':id' => $id_taxa
        ]);
        $msg = "Taxa atualizada com sucesso.";
    } else {
        // Insere nova taxa
        $sql = "INSERT INTO bairros_taxas (estabelecimento_id, nome_bairro, taxa) VALUES (:estabelecimento_id, :nome_bairro, :taxa)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':estabelecimento_id' => $estabelecimento_id,
            ':nome_bairro' => $nome_bairro,
            ':taxa' => $taxa
        ]);
        $msg = "Taxa cadastrada com sucesso.";
    }
    echo json_encode(['status' => 'success', 'msg' => $msg]);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'msg' => 'Erro ao salvar taxa: ' . $e->getMessage()]);
}
