<?php
// listar_taxas.php
require_once 'conexao.php';

header('Content-Type: application/json');

try {
    if (isset($_GET['id']) && is_numeric($_GET['id'])) {
        // Buscar taxa específica para edição
        $id = (int)$_GET['id'];
        $stmt = $pdo->prepare("
            SELECT bt.*, u.nome AS estabelecimento_nome, u.id AS estabelecimento_id
            FROM bairros_taxas bt
            INNER JOIN usuarios u ON bt.estabelecimento_id = u.id
            WHERE bt.id = :id
            LIMIT 1
        ");
        $stmt->execute([':id' => $id]);
        $dados = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($dados) {
            echo json_encode(['status' => 'success', 'data' => $dados]);
        } else {
            echo json_encode(['status' => 'error', 'msg' => 'Taxa não encontrada']);
        }
        exit;
    }

    // Listar todas as taxas
    $stmt = $pdo->query("
        SELECT bt.*, u.nome AS estabelecimento_nome
        FROM bairros_taxas bt
        INNER JOIN usuarios u ON bt.estabelecimento_id = u.id
        ORDER BY u.nome, bt.nome_bairro
    ");
    $taxas = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['status' => 'success', 'data' => $taxas]);

} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'msg' => 'Erro ao listar taxas: ' . $e->getMessage()]);
}
