<?php
// excluir_taxas.php
require_once 'conexao.php';

header('Content-Type: application/json');

if (!isset($_POST['id']) || !is_numeric($_POST['id'])) {
    echo json_encode(['status' => 'error', 'msg' => 'ID inválido']);
    exit;
}

$id = (int)$_POST['id'];

try {
    $stmt = $pdo->prepare("DELETE FROM bairros_taxas WHERE id = :id");
    $stmt->execute([':id' => $id]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(['status' => 'success', 'msg' => 'Taxa excluída com sucesso.']);
    } else {
        echo json_encode(['status' => 'error', 'msg' => 'Taxa não encontrada ou já excluída.']);
    }
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'msg' => 'Erro ao excluir taxa: ' . $e->getMessage()]);
}
