<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require_once '../conexao.php';

startSecureSession();

// Verifique se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecionar se o usuário não estiver logado
    header("Location: user_login.html");
    exit();
}

// Obter o id do usuário logado
$user_id = $_SESSION['user_id'];


// Conectar ao banco de dados
try {
    $db = getDB();

    // Consultar o total de pedidos para o usuário baseado no provider_id
    $stmt = $db->prepare("SELECT COUNT(*) FROM services WHERE provider_id = ?");
    $stmt->execute([$user_id]);
    
    // Recuperar o total de pedidos
    $total_pedidos = $stmt->fetchColumn();
} catch (Exception $e) {
    // Em caso de erro, logar e definir total_pedidos como 0
    error_log("Erro ao buscar total de pedidos: " . $e->getMessage());
    $total_pedidos = 0;
}

// Conectar ao banco de dados
try {
    $db = getDB();

    // Consultar o nome do usuário e o último acesso (updated_at)
    $stmt = $db->prepare("SELECT name, updated_at, profile_image FROM users WHERE id = ?");

    
    

    $stmt->execute([$user_id]);
    
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
$user_name = $user ? $user['name'] : 'Usuário';
$last_access = $user['updated_at'] ?? null;
$profile_image = $user['profile_image'] ?? ''; // Aqui ele deve ser preenchido corretamente


    // Formatar o último acesso para uma data legível
    if ($last_access) {
        $last_access_formatted = date("d/m/Y às H:i", strtotime($last_access));
    } else {
        $last_access_formatted = 'Nunca';
    }
    
    
    
    // Consultar a média de avaliações do prestador (baseado no id_pedido_servico)
    $stmt_rating = $db->prepare("
        SELECT AVG(nota) AS avg_rating 
        FROM avaliacoes 
        WHERE id_pedido_servico IN (
            SELECT id FROM service_orders WHERE provider_id = ?
        )
    ");
    $stmt_rating->execute([$user_id]);  // $user_id é o ID do prestador
    $rating_data = $stmt_rating->fetch(PDO::FETCH_ASSOC);
    
    // Definir a média de avaliação, se disponível
    $avg_rating = $rating_data && $rating_data['avg_rating'] ? round($rating_data['avg_rating'], 1) : 0;

    // Definir a avaliação como excelente se for 4 ou mais
    $rating_status = $avg_rating >= 4 ? 'Excelente!' : 'Precisa melhorar';
    
  
    // Consultar a quantidade de serviços ativos (status = 'active')
    $stmt_active_services = $db->prepare("
        SELECT COUNT(*) AS active_services_count
        FROM services
        WHERE status = 'active' AND provider_id = ?
    ");
    $stmt_active_services->execute([$user_id]);  // Aqui você está contando os serviços ativos do prestador
    $active_services_data = $stmt_active_services->fetch(PDO::FETCH_ASSOC);
    $active_services_count = $active_services_data['active_services_count'];
    
    
} catch (Exception $e) {
    // Em caso de erro, logar e definir nome como "Usuário"
    error_log("Erro ao buscar nome do usuário: " . $e->getMessage());
    $user_name = 'Usuário';
    $last_access_formatted = 'Erro ao carregar';
     $avg_rating = 0;
    $rating_status = 'Erro ao carregar';
    
    // pedidos ativos
   $active_services_count = 0;
}


// Conectar ao banco de dados
try {
    $db = getDB();

    // Consultar o tipo de usuário (user_type) do usuário logado
    $stmt = $db->prepare("SELECT user_type FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    
    // Recuperar o tipo de usuário
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    $user_type = $user ? $user['user_type'] : 'client'; // Definindo como 'client' por padrão se não encontrado
} catch (Exception $e) {
    // Em caso de erro, logar e definir valores padrão
    error_log("Erro ao buscar tipo de usuário: " . $e->getMessage());
    $user_type = 'client'; // Definindo como 'client' por padrão em caso de erro
}



try {
    $db = getDB();

    $stmt = $db->prepare("SELECT name, updated_at, profile_image, user_type FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    $user_name = $user ? $user['name'] : 'Usuário';
    $last_access = $user['updated_at'] ?? null;
    $profile_image = $user['profile_image'] ?? '';
    $user_type = $user['user_type'] ?? '';

    if ($last_access) {
        $last_access_formatted = date("d/m/Y às H:i", strtotime($last_access));
    } else {
        $last_access_formatted = 'Nunca';
    }
} catch (Exception $e) {
    error_log("Erro ao buscar dados do usuário: " . $e->getMessage());
    $user_name = 'Usuário';
    $last_access_formatted = 'Erro ao carregar';
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Chat - ServiceConnect</title>
<link rel="stylesheet" href="../css/main.css" />





</head>
<body>

<!-- Header -->
<header class="bg-surface border-b border-border sticky top-0 z-50">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-between items-center h-16">
      <div class="flex items-center">
        <a href="homepage.php" class="flex items-center space-x-2">
          <svg class="w-8 h-8 text-primary" viewBox="0 0 32 32" fill="currentColor">
            <path d="M16 2L3 9v14c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V9L16 2z"/>
            <path d="M16 6L7 11v10c0 3.87 2.68 7.48 6.25 8.5 3.57-1.02 6.25-4.63 6.25-8.5V11L16 6z" fill="white"/>
          </svg>
          <span class="text-xl font-bold text-primary">ServiceConnect</span>
        </a>
      </div>

      <nav class="hidden md:flex items-center space-x-8">
        <?php if ($user_type != 'provider'): ?>
          <a href="homepage.php" class="text-text-secondary hover:text-primary transition-colors">Início</a>
          <a href="prestadores.php" class="text-text-secondary hover:text-primary transition-colors">Prestadores</a>
          <a href="meus_servicosCL.php" class="text-text-secondary hover:text-primary transition-colors">Meus Serviços</a>
        <?php endif; ?>

        <?php if ($user_type != 'client'): ?>
          <a href="meus_servicos.php" class="text-text-secondary hover:text-primary transition-colors">Meus Serviços</a>
          <a href="solicitacoes.php" class="text-text-secondary hover:text-primary transition-colors">Orçamentos</a>
        <?php endif; ?>

        <a href="chat_interface.php" class="text-text-secondary hover:text-primary transition-colors">Chat</a>
        <a href="pagamentos.php" class="text-text-secondary hover:text-primary transition-colors">Pagamentos</a>
      </nav>

      <div class="flex items-center space-x-4">
       <!-- <button class="relative p-2 text-text-secondary hover:text-primary transition-colors">
          <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-5 5v-5zM10.5 3.5a6 6 0 0 1 6 6v2l1.5 3h-15l1.5-3v-2a6 6 0 0 1 6-6z"/>
          </svg>
          <span class="absolute -top-1 -right-1 bg-error text-white text-xs rounded-full h-5 w-5 flex items-center justify-center">3</span>
        </button>
-->
        <div class="relative">
          <button id="profileDropdown" onclick="toggleDropdown()" class="flex items-center space-x-2 p-2 rounded-md hover:bg-gray-50 transition-colors">
            <img 
              src="https://tt.advopack.net/pages/CONFIG/uploads/<?php echo urlencode($profile_image); ?>" 
              alt="Profile" 
              class="w-8 h-8 rounded-full object-cover" 
              onerror="this.src='https://images.unsplash.com/photo-1584824486509-112e4181ff6b?q=80&w=2940&auto=format&fit=crop'; this.onerror=null;" />
            <span class="hidden md:block text-text-primary font-medium"><?php echo htmlspecialchars($user_name); ?></span>
            <svg class="w-4 h-4 text-text-secondary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
            </svg>
          </button>

          <div id="profileMenu" class="hidden absolute right-0 mt-2 w-48 bg-surface rounded-md shadow-modal border border-border z-50">
            <div class="py-1">
              <a href="homepage.php" class="flex items-center px-4 py-2 text-sm text-primary bg-primary-50">
                <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"/>
                </svg>
               Home
              </a>
              <a href="user_dashboard.php" class="flex items-center px-4 py-2 text-sm text-text-primary hover:bg-gray-50">
                <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                </svg>
                Meu Perfil
              </a>
              <a href="edit_user.php" class="flex items-center px-4 py-2 text-sm text-text-primary hover:bg-gray-50">
                <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1 1 0 00.951-.69l1.07-3.292z"/>
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
                Configurações
              </a>
              <div class="border-t border-border"></div>
              <a href="../php/auth/logout.php" class="flex items-center px-4 py-2 text-sm text-error hover:bg-error-50">
                <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                </svg>
                Sair
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>

<script>
function toggleDropdown() {
  const menu = document.getElementById('profileMenu');
  menu.classList.toggle('hidden');
}
document.addEventListener('click', function(event) {
  const dropdown = document.getElementById('profileMenu');
  const dropdownButton = document.getElementById('profileDropdown');
  if (!dropdown.contains(event.target) && !dropdownButton.contains(event.target)) {
    dropdown.classList.add('hidden');
  }
});
</script>

<!-- ======== APP BODY ======== -->
<div id="containerPrincipal">
  <!-- Lista de conversas -->
  <div id="conversas">
    <h3>Conversas</h3>
    <div id="listaConversas"></div>
  </div>

  <!-- Tela do chat -->
  <div id="chat">
    <!-- Cabeçalho -->
    <div class="chat-header">
      <button class="chat-back" onclick="voltarParaConversas()" aria-label="Voltar">
        <svg width="18" height="18" viewBox="0 0 24 24"><path fill="currentColor" d="M15.5 19a1 1 0 0 1-.7-.29l-6-6a1 1 0 0 1 0-1.42l6-6a1 1 0 0 1 1.4 1.42L10.91 12l5.29 5.29A1 1 0 0 1 15.5 19z"/></svg>
      </button>

      <div class="chat-peer">
        <img id="peerAvatar" src="" alt="Avatar"/>
        <div>
          <div class="name" id="peerName">Contato</div>
          
          <div class="status" id="peerStatus">Conversa monitorada</div>
        </div>
      </div>

      <div class="chat-actions">
      <?php if ($user_type != 'client'): ?>
    <!-- NOVO: botão Enviar Proposta (provider) -->
    <button id="btnHeaderProposta" title="Enviar proposta" aria-label="Enviar proposta" onclick="abrirModalProposta()">
      <!-- ícone de documento/moeda -->
      <svg width="18" height="18" viewBox="0 0 24 24">
        <path fill="currentColor" d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
        <path fill="#fff" d="M14 2v6h6"/>
        <path fill="#fff" d="M12 14a3 3 0 1 0 3 3h-2a1 1 0 1 1-1-1h3a3 3 0 0 0-3-3z"/>
      </svg>
    </button>
  <?php endif; ?>
        <!--<button title="Vídeo" aria-label="Vídeo">
          <svg width="18" height="18" viewBox="0 0 24 24"><path fill="currentColor" d="M17 10.5V7a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2v-3.5L22 17V7z"/></svg>
        </button> 
        <button title="Mais" aria-label="Mais">
          <svg width="18" height="18" viewBox="0 0 24 24"><path fill="currentColor" d="M12 8a2 2 0 1 0-2-2a2 2 0 0 0 2 2m0 2a2 2 0 1 0 2 2a2 2 0 0 0-2-2m0 6a2 2 0 1 0 2 2a2 2 0 0 0-2-2"/></svg>
        </button> -->
      </div>
    </div>

    <!-- Mensagens -->
    <div id="mensagens"></div>

    <!-- Input -->
    <form id="formMensagem" class="chat-input">
      <input type="hidden" id="destinatario" name="destinatario" />
      <div class="input-wrap">
        <!--<button class="input-btn" type="button" title="Anexo">
          <svg width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M7 18a5 5 0 0 1 0-7l6-6a4 4 0 0 1 6 6l-7 7a3 3 0 0 1-4-4l7-7a1 1 0 0 1 1.41 1.41l-7 7a1 1 0 1 0 1.41 1.41l7-7a3 3 0 0 0-4.24-4.24l-6 6A3 3 0 0 0 7 18"/></svg>
        </button> -->
        <!--<button class="input-btn" type="button" title="Câmera">
          <svg width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M9.4 4l1.2 1.5H14a2 2 0 0 1 2 2v9a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2v-9a2 2 0 0 1 2-2h1.4L8.6 4zM10 12a3 3 0 1 0 6 0a3 3 0 0 0-6 0"/></svg>
        </button> -->
        <textarea id="mensagem" name="mensagem" rows="1" placeholder="Digite sua mensagem..." aria-label="Mensagem"></textarea>
        <!-- Botão Localização -->
<button id="btnLocation" class="input-btn" type="button" title="Enviar localização">
  <svg width="20" height="20" viewBox="0 0 24 24">
    <path fill="currentColor" d="M12 2a8 8 0 0 0-8 8c0 5.25 8 12 8 12s8-6.75 8-12a8 8 0 0 0-8-8zm0 10.5a2.5 2.5 0 1 1 0-5a2.5 2.5 0 0 1 0 5z"/>
  </svg>
</button>

        <button class="btn-send" type="submit" aria-label="Enviar">
          <svg width="18" height="18" viewBox="0 0 24 24"><path fill="currentColor" d="m3.4 20.4l18.3-8.2a1 1 0 0 0 0-1.8L3.4 2.2A1 1 0 0 0 2 3.3l2.1 6.4l7.5 1.9l-7.5 1.9L2 19.9a1 1 0 0 0 1.4.5"/></svg>
        </button>
      </div>
    </form>
  </div>
</div>

<!-- ======== MODAL PROPOSTA ======== -->
<div id="modalProposta" class="flex">
  <div class="modal-content">
    <button onclick="fecharModalProposta()" class="close-btn">&times;</button>
    <h2 class="text-lg font-semibold mb-4">Enviar Proposta</h2>

    <form id="formProposta">
      <div class="mb-3">
        <label for="client_id">ID do Cliente</label>
        <input type="number" id="client_id" name="client_id" required>
      </div>
      <div class="mb-3">
        <label for="titulo">Título</label>
        <input type="text" id="titulo" name="titulo" required>
      </div>
      <div class="mb-3">
        <label for="descricao">Descrição</label>
        <textarea id="descricao" name="descricao" rows="3" required></textarea>
      </div>
      <div class="mb-3">
        <label for="valor">Valor (R$)</label>
        <input type="number" step="0.01" id="valor" name="valor" required>
      </div>
      <div class="mb-3">
        <label for="duracao">Duração (minutos)</label>
        <input type="number" id="duracao" name="duracao" required>
      </div>
      <div class="mb-3">
        <label for="local">Local</label>
        <input type="text" id="local" name="local" required>
      </div>
      <div class="mb-3">
        <label for="data">Data</label>
        <input type="date" id="data" name="data" required>
      </div>
      <input type="hidden" id="provider_id" name="provider_id" value="<?= $_SESSION['user_id'] ?>">
      <button type="submit">Enviar Proposta</button>
    </form>

    <div id="respostaProposta" class="mt-3 text-sm text-center"></div>
  </div>
</div>

<!-- ======== BOTTOM NAV (MOBILE) ======== -->
<nav id="mobileBottomNav" class="md:hidden fixed bottom-0 left-0 right-0 bg-surface border-t border-border z-50">
  <div class="grid grid-cols-5 h-16">
    <a href="homepage.php" class="flex flex-col items-center justify-center text-text-secondary hover:text-primary transition-colors">
      <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
      </svg>
      <span class="text-xs mt-1">Início</span>
    </a>

    <?php if ($user_type != 'provider'): ?>
    <a href="prestadores.php" class="flex flex-col items-center justify-center text-text-secondary hover:text-primary transition-colors">
      <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
      </svg>
      <span class="text-xs mt-1">Buscar</span>
    </a>
    <a href="meus_servicosCL.php" class="flex flex-col items-center justify-center text-text-secondary hover:text-primary transition-colors">
      <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
      </svg>
      <span class="text-xs mt-1">Meus Serviços</span>
    </a>
    <?php endif; ?>

    <?php if ($user_type != 'client'): ?>
    <a href="meus_servicos.php" class="flex flex-col items-center justify-center text-text-secondary hover:text-primary transition-colors">
      <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
      </svg>
      <span class="text-xs mt-1">Meus Serviços</span>
    </a>
    <a href="solicitacoes.php" class="flex flex-col items-center justify-center text-text-secondary hover:text-primary transition-colors">
      <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
      </svg>
      <span class="text-xs mt-1">Orçamentos</span>
    </a>
    <?php endif; ?>

    <a href="chat_interface.php" class="flex flex-col items-center justify-center text-primary bg-primary-50 transition-colors">
      <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
      </svg>
      <span class="text-xs mt-1">Chat</span>
    </a>

    <a href="user_dashboard.php" class="flex flex-col items-center justify-center text-text-secondary hover:text-primary transition-colors">
      <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"/>
      </svg>
      <span class="text-xs mt-1">Dashboard</span>
    </a>
  </div>
</nav>

<!-- ======== SCRIPTS DO APP ======== -->
<script>
const listaConversas = document.getElementById('listaConversas');
const mensagensDiv = document.getElementById('mensagens');
const formMensagem = document.getElementById('formMensagem');
const destinatarioInput = document.getElementById('destinatario');

let conversaSelecionadaId = null;
let conversaSelecionadaNome = '';
let conversaSelecionadaImagem = '';
let conversaSelecionadaClientId = null;

const userId = <?= json_encode($_SESSION['user_id']) ?>;

function escapeHtml(s){
  return String(s ?? '').replace(/[&<>"]/g, t=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;'}[t]));
}

function carregarConversas() {
  fetch('/pages/chat/listar_conversas.php')
    .then(res => res.json())
    .then(data => {
      if (data.erro) { alert(data.erro); return; }
      listaConversas.innerHTML = '';
      data.forEach(conversa => {
        const div = document.createElement('div');
        div.className = 'conversa-item';
        div.tabIndex = 0;

        const media = conversa.media_avaliacao ? Number(conversa.media_avaliacao).toFixed(1) : 'N/D';
        const ultima = conversa.ultima_mensagem ? escapeHtml(conversa.ultima_mensagem) : '';
        const dataTxt = conversa.ultima_data ? new Date(conversa.ultima_data).toLocaleString() : '';

        div.innerHTML = `
          <img src="${conversa.outro_imagem_url}" alt="Foto de ${escapeHtml(conversa.outro_nome)}" class="conversa-img" />
          <div class="conversa-textos">
            <div class="conversa-header">
              <strong class="conversa-nome">${escapeHtml(conversa.outro_nome)}</strong>
              <span class="conversa-estrela">★ ${media}</span> <br>
               <?php if ($user_type != 'client'): ?>
              <small class="conversa-id">ID: ${conversa.id_client}</small>
              <?php endif; ?>
            </div>
            <p class="conversa-ultima-mensagem">${ultima}</p>
            <small class="conversa-data">${dataTxt}</small>
          </div>
        `;

        div.addEventListener('click', () => abrirConversa(
          conversa.conversa_id,
          conversa.outro_nome,
          conversa.outro_imagem_url,
          conversa.client_id
        ));

        div.addEventListener('keydown', e => {
          if (e.key === 'Enter' || e.key === ' ') {
            e.preventDefault();
            div.click();
          }
        });

        listaConversas.appendChild(div);
      });
    })
    .catch(e => alert('Erro ao carregar conversas: ' + e.message));
}

function abrirConversa(conversa_id, nomeOutro, imagemOutro, clientId){
  conversaSelecionadaId = conversa_id;
  conversaSelecionadaNome = nomeOutro || '';
  conversaSelecionadaImagem = imagemOutro || '';
  conversaSelecionadaClientId = clientId || null;
  destinatarioInput.value = conversa_id;

  const fallback = 'https://lh5.googleusercontent.com/proxy/m_WOBdrygsvNlNlWCXemBGyxKX16r1zaDmCHtg5UksoFf2FFDGSqxZtz_Ew0EHDQO3jTLi7sBBNPp6Hz1v2Qcpvg';
  const avatarUrl = (typeof imagemOutro === 'string' && imagemOutro.trim() !== '')
    ? `https://tt.advopack.net/pages/CONFIG/uploads/${encodeURIComponent(imagemOutro.trim())}`
    : fallback;

  document.getElementById('peerName').textContent = conversaSelecionadaNome;
  document.getElementById('peerAvatar').src = avatarUrl;
  document.getElementById('peerAvatar').onerror = function(){ this.src = fallback };

  document.getElementById('conversas').style.display = 'none';
  document.getElementById('chat').classList.add('active');

  const bottomNav = document.getElementById('mobileBottomNav');
  if (bottomNav){ bottomNav.classList.add('hidden'); bottomNav.style.display='none'; }

  mensagensDiv.innerHTML = '<p style="color:#64748B; padding:.5rem 1rem">Carregando mensagens...</p>';

  fetch(`/pages/chat/listar_mensagens.php?conversa_id=${conversa_id}`)
    .then(res=>res.json())
    .then(data=>{
      if(data.erro){ alert(data.erro); mensagensDiv.innerHTML=''; return; }
      mensagensDiv.innerHTML='';
      data.forEach(msg=>{
        const itsMe = (msg.remetente_id == userId);
        const wrap = document.createElement('div');
        wrap.className = `msg ${itsMe ? 'mine' : 'their'}`;
        wrap.innerHTML = `
          <div class="bubble">${escapeHtml(msg.mensagem)}</div>
          <div class="time">${new Date(msg.created_at).toLocaleString()}</div>
        `;
        mensagensDiv.appendChild(wrap);
      });
      mensagensDiv.scrollTop = mensagensDiv.scrollHeight;
    })
    .catch(e=>{ alert('Erro ao carregar mensagens: '+e.message); mensagensDiv.innerHTML=''; });
}

function voltarParaConversas(){
  document.getElementById('chat').classList.remove('active');
  document.getElementById('conversas').style.display='flex';
  const bottomNav = document.getElementById('mobileBottomNav');
  if(bottomNav){ bottomNav.classList.remove('hidden'); bottomNav.style.display=''; }
  document.getElementById('peerName').textContent = 'Contato';
  document.getElementById('peerAvatar').src = '';
}

// Auto-expand do textarea (até 120px)
document.addEventListener('input', function (e) {
  if (e.target && e.target.id === 'mensagem') {
    const ta = e.target;
    ta.style.height = 'auto';
    ta.style.height = Math.min(ta.scrollHeight, 120) + 'px';
  }
});

// Enviar com Enter (Shift+Enter = nova linha)
(function enableEnterToSend() {
  const ta = document.getElementById('mensagem');
  if (!ta) return;
  ta.addEventListener('keydown', function (e) {
    if (e.key === 'Enter' && !e.shiftKey) {
      e.preventDefault();
      formMensagem.requestSubmit(); // dispara o submit do form
    }
  });
})();

// Util para escapar HTML
function escapeHtml(s) {
  return String(s ?? '').replace(/[&<>"]/g, t => ({
    '&': '&amp;', '<': '&lt;', '>': '&gt;', '"': '&quot;'
  }[t]));
}

// Adiciona mensagem na UI (optimistic)
function appendMessageToUI({ text, itsMe = true, ts = new Date() }) {
  const wrap = document.createElement('div');
  wrap.className = `msg ${itsMe ? 'mine' : 'their'}`;
  wrap.innerHTML = `
    <div class="bubble">${escapeHtml(text)}</div>
    <div class="time">${new Date(ts).toLocaleString()}</div>
  `;
  mensagensDiv.appendChild(wrap);
  mensagensDiv.scrollTop = mensagensDiv.scrollHeight;
}

// SUBMIT do formulário
formMensagem.addEventListener('submit', async (e) => {
  e.preventDefault();

  const ta = document.getElementById('mensagem');
  const mensagem = ta.value.trim();

  if (!conversaSelecionadaId) {
    alert('Selecione uma conversa e digite uma mensagem.');
    return;
  }
  if (!mensagem) return;

  // Optimistic render
  appendMessageToUI({ text: mensagem, itsMe: true });

  // Bloqueia enquanto envia
  const sendBtn = formMensagem.querySelector('[type="submit"]');
  const prevDisabled = { ta: ta.disabled, btn: sendBtn ? sendBtn.disabled : false };
  ta.disabled = true;
  if (sendBtn) sendBtn.disabled = true;

  try {
    const res = await fetch('/pages/chat/enviar_mensagem.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ conversa_id: conversaSelecionadaId, mensagem })
    });
    const data = await res.json();

    if (data.erro) {
      // Se falhar, remove a bolha otimista e alerta
      mensagensDiv.lastElementChild?.remove(); // remove time
      mensagensDiv.lastElementChild?.remove(); // remove bubble
      alert(data.erro);
      return;
    }

    // Sucesso: limpa textarea e mantém na conversa atual
    ta.value = '';
    ta.style.height = 'auto';
    // opcional: atualizar lista de conversas (última msg/horário)
    carregarConversas();
  } catch (err) {
    // Falha de rede: reverte a bolha otimista
    mensagensDiv.lastElementChild?.remove();
    mensagensDiv.lastElementChild?.remove();
    alert('Erro ao enviar mensagem: ' + err.message);
  } finally {
    // Restaura estado
    ta.disabled = prevDisabled.ta;
    if (sendBtn) sendBtn.disabled = prevDisabled.btn;
    ta.focus();
  }
});


function abrirModalProposta(){ document.getElementById('modalProposta').classList.add('active'); }
function fecharModalProposta(){ document.getElementById('modalProposta').classList.remove('active'); }

document.getElementById('formProposta').addEventListener('submit', function(e) {
  e.preventDefault();
  const titulo = document.getElementById('titulo').value;
  const descricao = document.getElementById('descricao').value;
  const valor = document.getElementById('valor').value;
  const duracao = document.getElementById('duracao').value;
  const local = document.getElementById('local').value;
  const data = document.getElementById('data').value;
  const provider_id = document.getElementById('provider_id').value;
  const client_id = document.getElementById('client_id').value;

  if (!titulo || !descricao || !valor || !duracao || !local || !data || !provider_id || !client_id) {
    alert('Por favor, preencha todos os campos obrigatórios!');
    return;
  }

  fetch('/pages/chat/processar_proposta.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: new URLSearchParams({ titulo, descricao, valor, duracao, local, data, provider_id, client_id })
  })
  .then(response => response.json())
  .then(data => {
    if (data.erro) { alert(data.erro); }
    else { alert(data.message); fecharModalProposta(); }
  })
  .catch(e => alert('Erro ao enviar proposta: ' + e.message));
});

document.addEventListener("DOMContentLoaded", carregarConversas);
</script>


<style>
/* ======== THEME & RESET ======== */
:root{
  --bg:#F4F6F8; --panel:#FFFFFF; --muted:#92A0AD; --text:#0F172A;
  --brand:#22C55E; --brand-600:#16A34A; --accent:#3B82F6;
  --bubble-me:#DCF8C6; --bubble-other:#F1F5F9; --chip:#EEF2FF;
  --ring: rgba(34,197,94,.15);
}
*{box-sizing:border-box} html,body{height:100%}
body{background:var(--bg); color:var(--text); -webkit-font-smoothing:antialiased; margin:0}

/* ======== LAYOUT MOBILE ======== */
#containerPrincipal{display:flex; flex-direction:column; gap:.75rem; padding:.75rem; height:calc(100dvh - 64px);}

/*** LISTA DE CONVERSAS ***/


#conversas{display:flex; flex-direction:column; background:var(--panel); border-radius:14px; box-shadow:0 4px 20px rgba(2,6,23,.06); overflow:hidden}
#conversas h3{padding:.9rem 1rem; font-weight:700; border-bottom:1px solid #E5E7EB}
#listaConversas{overflow:auto; -webkit-overflow-scrolling:touch}

.conversa-item{display:flex; gap:.75rem; align-items:center; padding:.9rem 1rem; border-bottom:1px solid #F3F4F6; cursor:pointer; background:#fff}
.conversa-item:last-child{border-bottom:none}
.conversa-item:active{background:#FAFAFA}
.conversa-img{width:44px; height:44px; border-radius:999px; object-fit:cover; flex:0 0 44px; box-shadow:0 0 0 2px #fff, 0 0 0 3px var(--ring)}
.conversa-textos{flex:1}
.conversa-header{display:flex; align-items:center; justify-content:space-between; margin-bottom:.15rem}
.conversa-nome{font-weight:600}
.conversa-estrela{font-size:.8rem; color:#F59E0B}
.conversa-ultima-mensagem{font-size:.9rem; color:#475569; white-space:nowrap; overflow:hidden; text-overflow:ellipsis}
.conversa-data{font-size:.7rem; color:#94A3B8}

/*** TELA DO CHAT ***/
#chat{display:none; flex-direction:column; background:var(--panel); border-radius:14px; box-shadow:0 4px 20px rgba(2,6,23,.06); overflow:hidden; height:100%}
#chat.active{display:flex}

/* Cabeçalho do chat */
.chat-header{display:flex; align-items:center; gap:.75rem; padding:.8rem 1rem; border-bottom:1px solid #E5E7EB; position:sticky; top:0; background:#fff; z-index:5}
.chat-back{display:inline-flex; align-items:center; justify-content:center; width:36px; height:36px; border-radius:10px; background:#F3F4F6; border:none}
.chat-peer{display:flex; align-items:center; gap:.6rem; flex:1}
.chat-peer img{width:40px; height:40px; border-radius:999px; object-fit:cover}
.chat-peer .name{font-weight:700}
.chat-peer .status{font-size:.78rem; color:#16A34A}
.chat-actions{display:flex; gap:.35rem}
.chat-actions button{width:36px; height:36px; display:inline-flex; align-items:center; justify-content:center; border-radius:10px; border:1px solid #E5E7EB; background:#fff}

/* Área de mensagens */
#mensagens{flex:1; overflow:auto; padding:10px 12px 80px; background:linear-gradient(#FAFAFB,#FFFFFF); -webkit-overflow-scrolling:touch
    
      /* NOVO: vira coluna flex para permitir align-self por mensagem */
  display:flex;
  flex-direction:column;
  
  /* IMAGEM DE FUNDO */
  background-image:
      /* leve véu p/ leitura */
    url('https://preview.redd.it/ts7vuoswhwf41.jpg?width=640&crop=smart&auto=webp&s=803e1cd74e328f84ee30108c86e7d38ec849fc8a');
  background-size: cover;
  background-position: center;
  background-repeat: no-repeat;
    
}
.msg{max-width:100%;   display:flex;    flex-direction:column; gap:.25rem; margin:.25rem 0}
.msg .bubble{padding:.6rem .8rem; border-radius:18px; line-height:1.3; box-shadow:0 1px 0 rgba(2,6,23,.05)}
.msg .time{font-size:.7rem; color:#94A3B8}
.msg.their{align-items:flex-start}
.msg.their .bubble{background:var(--bubble-other); border-top-left-radius:6px}
.msg.mine{align-items:flex-end}
.msg.mine .bubble{background:var(--bubble-me); border-top-right-radius:6px}
.msg.mine .time{text-align:right}

/* NOVO: posicionamento lateral */
.msg.their{align-self:flex-start}
.msg.their .bubble{background:var(--bubble-other); border-top-left-radius:6px}

/* Barra de envio fixa */
.chat-input{position:sticky; bottom:0; background:#fff; border-top:1px solid #E5E7EB; padding:.6rem .7rem}
.input-wrap{display:flex; gap:.5rem; align-items:center; background:#F1F5F9; border-radius:14px; padding:.35rem .45rem}
.input-btn{width:38px; height:38px; display:inline-flex; align-items:center; justify-content:center; border:none; background:transparent}
#mensagem{flex:1; border:none; background:transparent; padding:.55rem .2rem; font-size:15px; resize:none; max-height:120px; outline:none}
.btn-send{width:44px; height:44px; border:none; border-radius:12px; background:linear-gradient(135deg,var(--accent),#60A5FA); color:#fff; display:inline-flex; align-items:center; justify-content:center; box-shadow:0 8px 16px rgba(59,130,246,.25)}
.btn-send:active{transform:translateY(1px)}

/* Oculta chips antigos (manter compatibilidade) */
#chat-buttons{display:none}
.hidden{display:none !important}

/* Modal proposta base (mantido do seu código, com pequenos ajustes) */
#modalProposta {
  position: fixed; inset: 0; background-color: rgba(0,0,0,0.5);
  z-index: 50; display: none; align-items: center; justify-content: center; padding: 16px;
}
#modalProposta.active { display:flex; }
#modalProposta .modal-content {
  background-color:#fff; padding:24px; border-radius:12px; width:100%; max-width:480px;
  max-height:90vh; overflow-y:auto; position:relative; box-shadow:0 4px 12px rgba(0,0,0,0.15);
}
#modalProposta .close-btn { position:absolute; top:12px; right:12px; font-size:20px; color:#6b7280; background:none; border:none; cursor:pointer }
#modalProposta .close-btn:hover { color:#374151 }
#modalProposta button[type="submit"]{ width:100%; padding:12px; background-color:var(--brand-600); color:#fff; font-weight:600; border:none; border-radius:8px; cursor:pointer }
#modalProposta button[type="submit"]:hover{ background-color:#15803d }
#modalProposta input, #modalProposta textarea{ width:100%; padding:8px 10px; border:1px solid #d1d5db; border-radius:8px; font-size:14px; margin-top:4px }
#modalProposta label{ font-weight:500; font-size:14px; margin-bottom:2px; display:block }

/* Mobile header height compensation */
@media(min-width:768px){ #containerPrincipal{height:calc(100vh - 64px)} }
</style>

</body>
</html>
