<?php
include $_SERVER['DOCUMENT_ROOT'].'/conexao.php';  // Certifique-se de que o caminho está correto
session_start();

// Receber os dados JSON do frontend
$data = json_decode(file_get_contents('php://input'), true);  // Lê o corpo da requisição e decodifica para um array PHP

// Verificar se o conversa_id foi passado corretamente
$conversa_id = isset($data['conversa_id']) ? $data['conversa_id'] : null;  // Recebe o conversa_id ou null

error_log('Conversa ID recebido: ' . $conversa_id);  // Log de depuração

// Verificar se o conversa_id não é vazio
if (empty($conversa_id)) {
    error_log('Erro: conversa_id está vazio ou não foi enviado.');
    echo json_encode([]);  // Retorna um array vazio caso o ID não seja encontrado
    exit;
}

$sql = "SELECT m.mensagem, u.nome, m.data_envio
        FROM mensagens m
        JOIN usuarios u ON u.id = m.id_remetente
        WHERE m.id_conversa = :conversa_id
        ORDER BY m.data_envio ASC";

// Preparar a consulta com PDO
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':conversa_id', $conversa_id, PDO::PARAM_INT);

// Executar a consulta
$stmt->execute();

// Criar o array para armazenar as mensagens
$mensagens = [];

// Buscar as mensagens
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $row['data_envio'] = date('Y-m-d H:i:s', strtotime($row['data_envio']));
    $mensagens[] = $row;
}

// Log para verificar o conteúdo das mensagens
error_log('Mensagens retornadas: ' . print_r($mensagens, true));  // Log de depuração

// Retornar as mensagens em formato JSON
echo json_encode($mensagens);
?>
