<?php
include $_SERVER['DOCUMENT_ROOT'].'/conexao.php';  // Certifique-se de que o caminho está correto
session_start();

// Verificar se o usuário está logado
if (!isset($_SESSION['usuario'])) {
    die("Erro: Usuário não autenticado.");
}

// Obter o ID do usuário logado e o tipo de usuário (motoboy ou restaurante)
$user_id = $_SESSION['usuario']['id'];  // ID do usuário logado
$user_tipo = $_SESSION['usuario']['tipo'];  // Tipo de usuário (motoboy ou restaurante)

// Preparar a consulta para buscar os usuários
if ($user_tipo == 'motoboy') {
    // Se o usuário logado for um motoboy, carregar apenas os estabelecimentos
    $sql = "SELECT id, nome, tipo FROM usuarios WHERE tipo = 'restaurante'";
} elseif ($user_tipo == 'restaurante') {
    // Se o usuário logado for um restaurante, carregar apenas os motoboys
    $sql = "SELECT id, nome, tipo FROM usuarios WHERE tipo = 'motoboy'";
} else {
    // Caso o tipo de usuário não seja nem motoboy nem restaurante, retornar um erro
    die("Erro: Tipo de usuário desconhecido.");
}

// Preparar e executar a consulta com PDO
$stmt = $pdo->prepare($sql);
$stmt->execute();

// Criar o array de usuários
$usuarios = [];
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $usuarios[] = $row;
}

// Retornar os usuários em formato JSON
echo json_encode($usuarios);
?>
