<?php
session_start(); // Inicia a sessão, caso não tenha sido iniciada

// Verifica se o usuário está autenticado
$usuario = $_SESSION['usuario'] ?? null;
if (!$usuario || !isset($usuario['id'])) {
    echo 'Usuário não autenticado.';
    exit;
}

// Conexão com o banco de dados
require_once $_SERVER['DOCUMENT_ROOT'] . '/conexao.php'; // Caminho fixo para a conexão

// Pega o ID do usuário logado
$id_admin = $usuario['id']; // Supondo que o ID do usuário esteja armazenado em $_SESSION['usuario']['id']

// Prepara a consulta para obter os dados do usuário
$query = "SELECT nome, email, senha FROM usuarios WHERE id = :id";
$stmt = $pdo->prepare($query);

// Executa a consulta, passando o ID do usuário
$stmt->execute(['id' => $id_admin]);

// Busca os dados do usuário
$perfil = $stmt->fetch(PDO::FETCH_ASSOC);

// Verifica se o usuário foi encontrado
if ($perfil) {
    // Retorna os dados do perfil em formato JSON
    echo json_encode($perfil);
} else {
    // Caso o usuário não seja encontrado
    echo json_encode(['error' => 'Usuário não encontrado.']);
}
?>
