/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    './src/pages/**/*.{js,ts,jsx,tsx,mdx}',
    './src/components/**/*.{js,ts,jsx,tsx,mdx}',
    './src/app/**/*.{js,ts,jsx,tsx,mdx}',
  ],
  theme: {
    extend: {
      fontFamily: {
        sans: ['DM Sans', 'sans-serif'],
        heading: ['Plus Jakarta Sans', 'sans-serif'],
      },
      colors: {
        primary: {
          DEFAULT: '#011363',
          light: '#0a1f8f',
          dark: '#010e4a',
          50: '#eef1ff',
          100: '#dce4ff',
          200: '#b5c4ff',
          300: '#7d97ff',
          400: '#4062ff',
          500: '#1a3aff',
          600: '#0a1f8f',
          700: '#011363',
          800: '#010e4a',
          900: '#010931',
        },
        secondary: {
          DEFAULT: '#9ea3ba',
          light: '#c4c8d8',
          dark: '#6e7490',
        },
        accent: '#2d5be3',
        brand: {
          bg: '#f8f9fc',
          dark: '#030d3a',
        },
      },
      borderRadius: {
        'xl': '16px',
        '2xl': '24px',
        '3xl': '32px',
        '4xl': '40px',
      },
      boxShadow: {
        'soft': '0 2px 8px rgba(1, 19, 99, 0.06)',
        'card': '0 8px 32px rgba(1, 19, 99, 0.12)',
        'elevated': '0 20px 60px rgba(1, 19, 99, 0.18)',
        'glow': '0 0 40px rgba(45, 91, 227, 0.2)',
        'glow-lg': '0 12px 40px rgba(45, 91, 227, 0.4)',
      },
      backgroundImage: {
        'gradient-primary': 'linear-gradient(135deg, #011363 0%, #2d5be3 100%)',
        'gradient-hero': 'linear-gradient(135deg, #f0f3ff 0%, #e8ecff 30%, #f5f7ff 60%, #eef1ff 100%)',
        'gradient-text': 'linear-gradient(135deg, #011363 0%, #2d5be3 50%, #5b8af0 100%)',
      },
      animation: {
        'float': 'float-card 6s ease-in-out infinite',
        'float-slow': 'float-card-slow 8s ease-in-out infinite',
        'float-reverse': 'float-card-reverse 7s ease-in-out infinite',
        'pulse-glow': 'pulse-glow 3s ease-in-out infinite',
        'spin-slow': 'spin-slow 20s linear infinite',
        'shimmer': 'shimmer 2.5s ease-in-out infinite',
        'gradient': 'gradient-shift 4s ease infinite',
      },
      keyframes: {
        'float-card': {
          '0%, 100%': { transform: 'translateY(0px) rotate(0deg)' },
          '33%': { transform: 'translateY(-12px) rotate(0.5deg)' },
          '66%': { transform: 'translateY(-6px) rotate(-0.3deg)' },
        },
        'float-card-slow': {
          '0%, 100%': { transform: 'translateY(0px)' },
          '50%': { transform: 'translateY(-18px)' },
        },
        'float-card-reverse': {
          '0%, 100%': { transform: 'translateY(0px) rotate(0deg)' },
          '50%': { transform: 'translateY(10px) rotate(-0.5deg)' },
        },
        'pulse-glow': {
          '0%, 100%': { boxShadow: '0 0 20px rgba(45, 91, 227, 0.15)' },
          '50%': { boxShadow: '0 0 40px rgba(45, 91, 227, 0.35)' },
        },
        'spin-slow': {
          from: { transform: 'rotate(0deg)' },
          to: { transform: 'rotate(360deg)' },
        },
        'shimmer': {
          '0%': { transform: 'translateX(-100%)' },
          '100%': { transform: 'translateX(100%)' },
        },
        'gradient-shift': {
          '0%': { backgroundPosition: '0% 50%' },
          '50%': { backgroundPosition: '100% 50%' },
          '100%': { backgroundPosition: '0% 50%' },
        },
      },
      transitionTimingFunction: {
        'spring': 'cubic-bezier(0.16, 1, 0.3, 1)',
      },
    },
  },
  plugins: [],
}