"use client";

import Icon from "@/components/ui/AppIcon";
import AppImage from "@/components/ui/AppImage";

interface SystemCardProps {
  system: {
    id: string;
    name: string;
    description: string;
    segment: string;
    segmentIcon: string;
    image: string;
    imageAlt: string;
    features: string[];
    demoUrl: string;
    gradientFrom: string;
    gradientTo: string;
    accentColor: string;
  };
  onDemoClick: (system: { name: string; demoUrl: string; segment: string }) => void;
  animDelay?: string;
}

export default function SystemCard({ system, onDemoClick, animDelay = "delay-100" }: SystemCardProps) {
  return (
    <div className={`system-card reveal ${animDelay} flex flex-col`}>
      {/* Image */}
      <div className="relative overflow-hidden h-52 flex-shrink-0">
        <AppImage
          src={system.image}
          alt={system.imageAlt}
          fill
          className="object-cover transition-transform duration-700 group-hover:scale-110"
        />
        <div
          className="absolute inset-0"
          style={{
            background: `linear-gradient(to bottom, transparent 40%, ${system.gradientFrom}dd 100%)`,
          }}
        />
        <div className="absolute top-4 left-4">
          <span
            className="inline-flex items-center gap-1.5 rounded-full px-3 py-1 text-xs font-bold text-white border border-white/30"
            style={{ background: "rgba(0,0,0,0.35)", backdropFilter: "blur(8px)" }}
          >
            <Icon name={system.segmentIcon as any} size={11} />
            {system.segment}
          </span>
        </div>
      </div>

      {/* Content */}
      <div className="p-7 flex flex-col flex-1">
        <h3 className="font-heading font-bold text-xl text-primary-dark mb-2">
          {system.name}
        </h3>
        <p className="text-sm text-gray-500 leading-relaxed mb-5 flex-1">
          {system.description}
        </p>

        {/* Features */}
        <div className="mb-6">
          <p className="text-xs font-bold text-gray-400 uppercase tracking-wider mb-3">
            Funcionalidades principais
          </p>
          <ul className="space-y-2">
            {system.features.map((feature) => (
              <li key={feature} className="flex items-center gap-2.5 text-sm text-gray-600">
                <div
                  className="w-5 h-5 rounded-full flex items-center justify-center flex-shrink-0"
                  style={{ background: `${system.accentColor}18` }}
                >
                  <Icon name="CheckIcon" size={11} style={{ color: system.accentColor }} />
                </div>
                {feature}
              </li>
            ))}
          </ul>
        </div>

        {/* Actions */}
        <div className="flex items-center gap-3 pt-4 border-t border-gray-100">
          <button
            onClick={() =>
              onDemoClick({
                name: system.name,
                demoUrl: system.demoUrl,
                segment: system.segment,
              })
            }
            className="flex-1 flex items-center justify-center gap-2 py-3 rounded-xl font-heading font-bold text-sm text-white transition-all duration-300 hover:shadow-glow-lg hover:-translate-y-0.5"
            style={{
              background: `linear-gradient(135deg, ${system.gradientFrom} 0%, ${system.gradientTo} 100%)`,
            }}
          >
            <Icon name="PlayIcon" size={15} />
            Ver Demo
          </button>
          <button
            className="w-11 h-11 rounded-xl border border-gray-200 flex items-center justify-center text-gray-400 hover:text-primary hover:border-primary/30 hover:bg-primary-50 transition-all duration-200"
            title="Mais informações"
            aria-label="Mais informações"
          >
            <Icon name="InformationCircleIcon" size={18} />
          </button>
        </div>
      </div>
    </div>
  );
}