import type { Metadata } from "next";
import Header from "@/components/Header";
import Footer from "@/components/Footer";
import HeroSection from "./components/HeroSection";
import CapabilitiesSection from "./components/CapabilitiesSection";
import BenefitsSection from "./components/BenefitsSection";
import SystemsPreviewSection from "./components/SystemsPreviewSection";
import HowWeWorkSection from "./components/HowWeWorkSection";
import PricingSection from "./components/PricingSection";
import CtaBannerSection from "./components/CtaBannerSection";

export const metadata: Metadata = {
  title: "ADVOPACK — Sistemas Personalizados sob Demanda",
  description:
    "A ADVOPACK desenvolve sistemas 100% personalizados para o seu negócio. Integrações com APIs, automação de processos, gestão financeira, estoque, RH e muito mais. Tecnologia sob medida.",
  keywords: [
    "sistemas personalizados",
    "desenvolvimento sob demanda",
    "integração API",
    "automação de processos",
    "gestão empresarial",
    "ERP personalizado",
    "ADVOPACK",
  ],
  openGraph: {
    title: "ADVOPACK — Sistemas que se adaptam ao seu negócio",
    description:
      "Desenvolvimento de sistemas 100% personalizados. Integrações, automação e gestão completa para a sua empresa.",
    type: "website",
  },
};

export default function HomePage() {
  return (
    <main className="min-h-screen">
      <Header />
      <HeroSection />
      <CapabilitiesSection />
      <BenefitsSection />
      <SystemsPreviewSection />
      <HowWeWorkSection />
      <PricingSection />
      <CtaBannerSection />
      <Footer />
    </main>
  );
}