"use client";

import { useEffect, useRef } from "react";
import Link from "next/link";
import Icon from "@/components/ui/AppIcon";

const floatingCards = [
  {
    id: "card-automation",
    icon: "BoltIcon",
    title: "Automação Ativa",
    subtitle: "127 processos automatizados",
    badge: "Live",
    badgeColor: "bg-green-400",
    style: "top-[12%] right-[4%] w-56",
    animClass: "animate-float-card",
    delay: "0s",
  },
  {
    id: "card-integration",
    icon: "ArrowsRightLeftIcon",
    title: "APIs Integradas",
    subtitle: "34 integrações ativas",
    badge: "+12 hoje",
    badgeColor: "bg-blue-400",
    style: "top-[42%] right-[2%] w-52",
    animClass: "animate-float-slow",
    delay: "1.5s",
  },
  {
    id: "card-reports",
    icon: "ChartBarIcon",
    title: "Relatórios",
    subtitle: "Dados em tempo real",
    badge: "98.7% uptime",
    badgeColor: "bg-accent",
    style: "bottom-[18%] right-[8%] w-54",
    animClass: "animate-float-reverse",
    delay: "0.8s",
  },
  {
    id: "card-clients",
    icon: "BuildingOffice2Icon",
    title: "Clientes Ativos",
    subtitle: "Projetos em produção",
    value: "48+",
    style: "top-[20%] left-[2%] w-48",
    animClass: "animate-float-slow",
    delay: "2s",
  },
];

export default function HeroSection() {
  const heroRef = useRef<HTMLElement>(null);

  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            entry.target.classList.add("visible");
          }
        });
      },
      { threshold: 0.1 }
    );

    const elements = document.querySelectorAll(".reveal, .reveal-left, .reveal-right");
    elements.forEach((el) => observer.observe(el));
    return () => observer.disconnect();
  }, []);

  return (
    <section
      ref={heroRef}
      className="hero-bg grid-pattern relative min-h-screen flex items-center overflow-hidden pt-20"
    >
      {/* Decorative rings */}
      <div className="absolute top-1/2 right-1/4 -translate-y-1/2 pointer-events-none hidden lg:block">
        <div className="w-[600px] h-[600px] rounded-full border border-primary/5 animate-spin-slow" />
        <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[450px] h-[450px] rounded-full border border-primary/8" />
        <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[300px] h-[300px] rounded-full border border-accent/10" />
        <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[150px] h-[150px] rounded-full bg-gradient-to-br from-primary/8 to-accent/8" />
      </div>

      <div className="max-w-7xl mx-auto px-6 lg:px-8 w-full py-20">
        <div className="grid lg:grid-cols-2 gap-16 items-center">
          {/* Left Content */}
          <div className="relative z-10">
            <div className="reveal">
              <span className="section-label mb-6 inline-flex">
                <span className="w-2 h-2 rounded-full bg-accent animate-pulse" />
                Desenvolvimento sob demanda
              </span>
            </div>

            <h1 className="font-heading font-extrabold leading-[1.05] mb-6 reveal delay-100">
              <span className="text-5xl lg:text-6xl xl:text-7xl text-primary-dark block">
                Sistemas que se
              </span>
              <span className="text-5xl lg:text-6xl xl:text-7xl gradient-text block">
                adaptam ao seu
              </span>
              <span className="text-5xl lg:text-6xl xl:text-7xl text-primary-dark block">
                negócio.
              </span>
              <span className="text-3xl lg:text-4xl text-secondary-dark font-medium block mt-2">
                Não o contrário.
              </span>
            </h1>

            <p className="text-lg text-gray-600 leading-relaxed max-w-xl mb-10 reveal delay-200">
              Desenvolvemos sistemas 100% personalizados para a realidade da sua empresa.
              Integrações inteligentes com APIs, automação de processos e gestão completa —
              financeiro, estoque, RH e muito mais.
            </p>

            <div className="flex flex-wrap gap-4 mb-12 reveal delay-300">
              <Link href="/homepage#contato" className="btn-primary text-base px-8 py-4">
                <Icon name="RocketLaunchIcon" size={18} />
                Solicitar Demonstração
              </Link>
              <Link href="/systems" className="btn-secondary text-base px-8 py-4">
                <Icon name="EyeIcon" size={18} />
                Ver Sistemas
              </Link>
            </div>

            {/* Trust Indicators */}
            <div className="flex flex-wrap items-center gap-6 reveal delay-400">
              {[
                { icon: "CheckBadgeIcon", text: "100% personalizado" },
                { icon: "ShieldCheckIcon", text: "Dados protegidos" },
                { icon: "ClockIcon", text: "Suporte dedicado" },
              ].map((item) => (
                <div key={item.text} className="flex items-center gap-2 text-sm text-gray-500 font-medium">
                  <Icon name={item.icon as any} size={16} className="text-accent" />
                  {item.text}
                </div>
              ))}
            </div>
          </div>

          {/* Right — Floating Cards Visual */}
          <div className="relative hidden lg:block h-[600px]">
            {/* Central hub */}
            <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2">
              <div className="w-32 h-32 rounded-3xl bg-gradient-to-br from-primary to-accent flex items-center justify-center shadow-glow-lg animate-pulse-glow">
                <Icon name="CpuChipIcon" size={52} className="text-white" />
              </div>
              {/* Connection lines */}
              <div className="absolute inset-0 -z-10">
                <svg width="400" height="400" className="absolute -top-[134px] -left-[134px] opacity-20">
                  <line x1="200" y1="200" x2="320" y2="80" stroke="#2d5be3" strokeWidth="1" strokeDasharray="4 4" />
                  <line x1="200" y1="200" x2="340" y2="230" stroke="#2d5be3" strokeWidth="1" strokeDasharray="4 4" />
                  <line x1="200" y1="200" x2="300" y2="340" stroke="#2d5be3" strokeWidth="1" strokeDasharray="4 4" />
                  <line x1="200" y1="200" x2="80" y2="120" stroke="#2d5be3" strokeWidth="1" strokeDasharray="4 4" />
                </svg>
              </div>
            </div>

            {/* Floating card 1 — Automation */}
            <div
              className="glass-card absolute rounded-2xl p-4 animate-float-card shadow-card"
              style={{ top: "8%", right: "0%", width: "220px", animationDelay: "0s" }}
            >
              <div className="flex items-center gap-3 mb-2">
                <div className="w-9 h-9 rounded-xl bg-green-100 flex items-center justify-center">
                  <Icon name="BoltIcon" size={18} className="text-green-600" />
                </div>
                <div>
                  <p className="text-xs font-bold text-primary font-heading">Automação Ativa</p>
                  <p className="text-[10px] text-gray-400">127 processos</p>
                </div>
                <span className="ml-auto flex items-center gap-1 text-[9px] font-bold text-green-600 bg-green-50 rounded-full px-2 py-0.5">
                  <span className="w-1.5 h-1.5 rounded-full bg-green-400 animate-pulse" />
                  Live
                </span>
              </div>
              <div className="w-full bg-gray-100 rounded-full h-1.5 overflow-hidden">
                <div className="h-full bg-gradient-to-r from-green-400 to-green-600 rounded-full shimmer-effect" style={{ width: "78%" }} />
              </div>
              <p className="text-[10px] text-gray-400 mt-1">78% eficiência ganha</p>
            </div>

            {/* Floating card 2 — Integrations */}
            <div
              className="glass-card absolute rounded-2xl p-4 animate-float-slow shadow-card"
              style={{ top: "42%", right: "-2%", width: "210px", animationDelay: "1.5s" }}
            >
              <div className="flex items-center gap-3 mb-3">
                <div className="w-9 h-9 rounded-xl bg-blue-100 flex items-center justify-center">
                  <Icon name="ArrowsRightLeftIcon" size={18} className="text-blue-600" />
                </div>
                <div>
                  <p className="text-xs font-bold text-primary font-heading">APIs Integradas</p>
                  <p className="text-[10px] text-gray-400">+12 esta semana</p>
                </div>
              </div>
              <div className="flex gap-1.5">
                {["ERP", "CRM", "NF-e", "PIX"].map((tag) => (
                  <span key={tag} className="text-[9px] font-bold bg-blue-50 text-blue-600 rounded-md px-1.5 py-0.5">
                    {tag}
                  </span>
                ))}
              </div>
            </div>

            {/* Floating card 3 — Reports */}
            <div
              className="glass-card absolute rounded-2xl p-4 animate-float-reverse shadow-card"
              style={{ bottom: "12%", right: "4%", width: "215px", animationDelay: "0.8s" }}
            >
              <div className="flex items-center gap-3 mb-2">
                <div className="w-9 h-9 rounded-xl bg-purple-100 flex items-center justify-center">
                  <Icon name="ChartBarIcon" size={18} className="text-purple-600" />
                </div>
                <div>
                  <p className="text-xs font-bold text-primary font-heading">Relatórios</p>
                  <p className="text-[10px] text-gray-400">Tempo real</p>
                </div>
              </div>
              <div className="flex items-end gap-1 h-8">
                {[40, 65, 45, 80, 55, 90, 70].map((h, i) => (
                  <div
                    key={i}
                    className="flex-1 rounded-sm bg-gradient-to-t from-primary to-accent opacity-70"
                    style={{ height: `${h}%` }}
                  />
                ))}
              </div>
            </div>

            {/* Floating card 4 — Clients */}
            <div
              className="glass-card absolute rounded-2xl p-4 animate-float-slow shadow-card"
              style={{ top: "18%", left: "0%", width: "185px", animationDelay: "2s" }}
            >
              <div className="flex items-center gap-2 mb-1">
                <div className="w-9 h-9 rounded-xl bg-orange-100 flex items-center justify-center">
                  <Icon name="BuildingOffice2Icon" size={18} className="text-orange-600" />
                </div>
                <p className="text-xs font-bold text-primary font-heading">Clientes Ativos</p>
              </div>
              <p className="text-3xl font-extrabold text-primary font-heading mt-1">48+</p>
              <p className="text-[10px] text-green-600 font-semibold">↑ 6 novos projetos este mês</p>
            </div>
          </div>
        </div>
      </div>

      {/* Scroll indicator */}
      <div className="absolute bottom-8 left-1/2 -translate-x-1/2 flex flex-col items-center gap-2 opacity-50">
        <span className="text-xs text-gray-400 tracking-widest uppercase font-medium">Scroll</span>
        <div className="w-5 h-8 border-2 border-gray-300 rounded-full flex items-start justify-center pt-1.5">
          <div className="w-1 h-2 bg-gray-400 rounded-full animate-bounce" />
        </div>
      </div>
    </section>
  );
}