"use client";

import { useEffect } from "react";
import Icon from "@/components/ui/AppIcon";

const benefits = [
  {
    icon: "UserGroupIcon",
    title: "Análise de Demanda",
    description: "Entendemos sua operação antes de escrever uma linha de código. Mapeamos processos, gargalos e oportunidades.",
    metric: "100%",
    metricLabel: "aderência ao processo",
  },
  {
    icon: "PuzzlePieceIcon",
    title: "Arquitetura Personalizada",
    description: "Cada módulo é desenhado para o seu fluxo. Interface intuitiva, regras de negócio específicas, relatórios customizados.",
    metric: "0",
    metricLabel: "limitações de template",
  },
  {
    icon: "LinkIcon",
    title: "Integrações Completas",
    description: "Conectamos com sistemas legados, ERPs, gateways financeiros, APIs de governo e qualquer serviço que você utilize.",
    metric: "50+",
    metricLabel: "tipos de integração",
  },
  {
    icon: "ShieldCheckIcon",
    title: "Segurança & Performance",
    description: "Infraestrutura robusta com criptografia, backups automáticos, monitoramento 24/7 e SLA garantido em contrato.",
    metric: "99.9%",
    metricLabel: "uptime garantido",
  },
  {
    icon: "DocumentTextIcon",
    title: "Documentação Completa",
    description: "Entregamos documentação técnica e manual do usuário. Você tem total controle e conhecimento sobre o sistema.",
    metric: "100%",
    metricLabel: "documentado",
  },
  {
    icon: "HeadphonesSpeakerIcon",
    title: "Suporte Dedicado",
    description: "Canal direto com a equipe técnica. Manutenções, evoluções e suporte contínuo para garantir sua operação.",
    metric: "24/7",
    metricLabel: "disponibilidade",
  },
];

export default function BenefitsSection() {
  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) entry.target.classList.add("visible");
        });
      },
      { threshold: 0.1 }
    );
    document.querySelectorAll(".reveal, .reveal-scale").forEach((el) => observer.observe(el));
    return () => observer.disconnect();
  }, []);

  return (
    <section className="py-24 bg-brand-bg" id="beneficios">
      <div className="max-w-7xl mx-auto px-6 lg:px-8">
        {/* Header */}
        <div className="flex flex-col lg:flex-row lg:items-end justify-between gap-8 mb-16">
          <div className="max-w-xl">
            <span className="section-label mb-4 reveal">
              <Icon name="StarIcon" size={12} />
              Por que a ADVOPACK
            </span>
            <h2 className="font-heading font-extrabold text-4xl lg:text-5xl text-primary-dark mt-4 reveal delay-100">
              Como entregamos
              <br />
              <span className="gradient-text">resultados reais</span>
            </h2>
          </div>
          <p className="text-gray-500 max-w-sm leading-relaxed reveal delay-200 lg:pb-2">
            Cada projeto começa com escuta ativa e termina com um sistema que a sua equipe
            realmente usa e aprecia.
          </p>
        </div>

        {/* Benefits Grid */}
        <div className="grid sm:grid-cols-2 lg:grid-cols-3 gap-6">
          {benefits.map((benefit, i) => (
            <div
              key={benefit.title}
              className={`bg-white rounded-2xl p-6 border border-gray-100 hover:border-primary/20 hover:shadow-card transition-all duration-400 group reveal delay-${Math.min((i + 1) * 100, 600)}`}
            >
              <div className="flex items-start justify-between mb-4">
                <div className="w-12 h-12 rounded-xl bg-primary-50 flex items-center justify-center group-hover:bg-primary transition-all duration-300">
                  <Icon
                    name={benefit.icon as any}
                    size={22}
                    className="text-primary group-hover:text-white transition-colors duration-300"
                  />
                </div>
                <div className="text-right">
                  <p className="font-heading font-extrabold text-2xl text-primary">{benefit.metric}</p>
                  <p className="text-[10px] text-gray-400 font-medium leading-tight">{benefit.metricLabel}</p>
                </div>
              </div>
              <h3 className="font-heading font-bold text-base text-primary-dark mb-2">
                {benefit.title}
              </h3>
              <p className="text-sm text-gray-500 leading-relaxed">{benefit.description}</p>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}