import Link from "next/link";
import AppLogo from "@/components/ui/AppLogo";
import Icon from "@/components/ui/AppIcon";

const footerLinks = [
  { label: "Início", href: "/homepage" },
  { label: "Sistemas", href: "/systems" },
  { label: "Preços", href: "/pricing" },
  { label: "Privacidade", href: "/homepage" },
  { label: "Termos", href: "/homepage" },
];

const socials = [
  { icon: "GlobeAltIcon", href: "#", label: "Website" },
  { icon: "EnvelopeIcon", href: "mailto:contato@advopack.com.br", label: "Email" },
  { icon: "PhoneIcon", href: "tel:+5511999999999", label: "WhatsApp" },
];

export default function Footer() {
  return (
    <footer className="bg-white border-t border-[#E2E5F0]">
      <div className="max-w-7xl mx-auto px-6 lg:px-8 py-12">
        <div className="flex flex-col md:flex-row items-center justify-between gap-6">
          {/* Logo + Brand */}
          <div className="flex items-center gap-3">
            <AppLogo size={36} text="ADVOPACK" iconName="CpuChipIcon" />
          </div>

          {/* Links */}
          <nav className="flex flex-wrap items-center justify-center gap-x-6 gap-y-2">
            {footerLinks.map((link) => (
              <Link
                key={link.label}
                href={link.href}
                className="text-sm font-medium text-[#6B7280] hover:text-[#011363] transition-colors duration-200"
              >
                {link.label}
              </Link>
            ))}
          </nav>

          {/* Social + Copyright */}
          <div className="flex items-center gap-4">
            {socials.map((s) => (
              <a
                key={s.label}
                href={s.href}
                aria-label={s.label}
                className="w-9 h-9 rounded-xl border border-[#E2E5F0] flex items-center justify-center text-[#6B7280] hover:text-[#011363] hover:border-[#011363] hover:bg-[#EEF0FA] transition-all duration-200"
              >
                <Icon name={s.icon as "GlobeAltIcon"} size={16} />
              </a>
            ))}
          </div>
        </div>

        <div className="mt-8 pt-6 border-t border-[#E2E5F0] flex flex-col sm:flex-row items-center justify-between gap-2 text-xs text-[#9ea3ba]">
          <span>© 2026 ADVOPACK Sistemas Personalizados. Todos os direitos reservados.</span>
          <span className="flex items-center gap-1">
            <Icon name="MapPinIcon" size={12} />
            Brasil
          </span>
        </div>
      </div>
    </footer>
  );
}