import type { Metadata } from "next";
import Header from "@/components/Header";
import Footer from "@/components/Footer";
import SystemsInteractive from "./components/SystemsInteractive";

export const metadata: Metadata = {
  title: "Sistemas | ADVOPACK — Catálogo de Soluções",
  description:
    "Conheça os sistemas desenvolvidos pela ADVOPACK para varejo, RH, financeiro, logística, saúde e indústria. Cada solução é 100% personalizada para sua operação.",
  keywords:
    "sistemas empresariais, ERP personalizado, software varejo, sistema RH, controle financeiro, gestão logística",
};

export default function SystemsPage() {
  return (
    <main className="min-h-screen bg-[#F8F9FF]">
      <Header />
      <SystemsInteractive />
      <Footer />
    </main>
  );
}