import type { Metadata } from "next";
import Header from "@/components/Header";
import Footer from "@/components/Footer";
import HomepageInteractive from "./components/HomepageInteractive";

export const metadata: Metadata = {
  title: "ADVOPACK | Sistemas Personalizados Sob Medida",
  description:
    "A ADVOPACK desenvolve sistemas 100% personalizados para sua empresa — integrações via APIs, automação de processos, gestão financeira, estoque, equipes e muito mais.",
  keywords:
    "sistemas personalizados, desenvolvimento sob medida, integração API, automação de processos, ERP personalizado, software empresarial",
  openGraph: {
    title: "ADVOPACK | Sistemas que se adaptam ao seu negócio",
    description:
      "Desenvolvimento de sistemas personalizados com integrações via APIs e automação de processos.",
    type: "website",
  },
};

export default function HomepagePage() {
  return (
    <main className="min-h-screen bg-[#F8F9FF]">
      <Header />
      <HomepageInteractive />
      <Footer />
    </main>
  );
}