"use client";

import { useEffect, useRef } from "react";
import Icon from "@/components/ui/AppIcon";
import AppImage from "@/components/ui/AppImage";

const testimonials = [
{
  quote:
  "A ADVOPACK entendeu nossa operação do zero e entregou um sistema que automatizou 80% dos nossos processos administrativos. O retorno sobre o investimento foi imediato.",
  name: "Ricardo Mendes",
  role: "Diretor de Operações",
  company: "Distribuidora Mendes & Filhos",
  avatar: "https://img.rocket.new/generatedImages/rocket_gen_img_13286bf9f-1765607080428.png",
  metric: "80% de automação",
  metricLabel: "nos processos"
},
{
  quote:
  "Tentamos dois softwares prontos antes e nenhum atendia nossa necessidade. Com a ADVOPACK, em 3 meses tínhamos o sistema exato que precisávamos, integrado com nosso ERP fiscal.",
  name: "Camila Figueiredo",
  role: "CEO",
  company: "Figueiredo Construtora Ltda",
  avatar: "https://img.rocket.new/generatedImages/rocket_gen_img_1c0db7d3c-1771542447035.png",
  metric: "3 meses",
  metricLabel: "da análise ao go-live"
},
{
  quote:
  "O suporte pós-implantação é excepcional. Sempre que precisamos de ajustes ou novas funcionalidades, a equipe atende com agilidade e profissionalismo.",
  name: "Fernando Alves",
  role: "Gerente de TI",
  company: "Grupo Alves Agronegócios",
  avatar: "https://img.rocket.new/generatedImages/rocket_gen_img_18d934ff8-1768061813709.png",
  metric: "24h",
  metricLabel: "tempo médio de resposta"
}];


export default function TestimonialsSection() {
  const sectionRef = useRef<HTMLElement>(null);

  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            entry.target.querySelectorAll(".reveal-hidden").forEach((el) => {
              el.classList.remove("reveal-hidden");
            });
          }
        });
      },
      { threshold: 0.08 }
    );
    if (sectionRef?.current) observer?.observe(sectionRef?.current);
    return () => observer?.disconnect();
  }, []);

  return (
    <section ref={sectionRef} className="py-24 bg-white" id="testimonials">
      <div className="max-w-7xl mx-auto px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-16 reveal reveal-hidden">
          <div className="section-label inline-flex mb-4">
            <Icon name="ChatBubbleLeftRightIcon" size={14} />
            Depoimentos
          </div>
          <h2 className="font-heading text-4xl lg:text-5xl font-bold text-[#0D1340] tracking-tight mt-4">
            O que nossos{" "}
            <span className="gradient-text">clientes dizem</span>
          </h2>
        </div>

        {/* Cards Grid */}
        <div className="grid md:grid-cols-3 gap-6">
          {testimonials?.map((t, i) =>
          <div
            key={t?.name}
            className={`testimonial-card p-6 reveal reveal-hidden reveal-delay-${i + 1}`}>
            
              {/* Stars */}
              <div className="flex gap-1 mb-4">
                {[...Array(5)]?.map((_, si) =>
              <Icon
                key={si}
                name="StarIcon"
                size={14}
                variant="solid"
                className="text-amber-400" />

              )}
              </div>

              {/* Quote */}
              <blockquote className="text-sm text-[#6B7280] leading-relaxed mb-6 italic">
                "{t?.quote}"
              </blockquote>

              {/* Metric */}
              <div className="bg-[#EEF0FA] rounded-xl p-3 mb-5 flex items-center gap-3">
                <div className="stat-number text-xl font-extrabold font-heading">
                  {t?.metric}
                </div>
                <div className="text-xs text-[#6B7280]">{t?.metricLabel}</div>
              </div>

              {/* Author */}
              <div className="flex items-center gap-3 pt-5 border-t border-[#E2E5F0]">
                <AppImage
                src={t?.avatar}
                alt={`Foto de ${t?.name}, ${t?.role} na ${t?.company}`}
                width={44}
                height={44}
                className="w-11 h-11 rounded-full object-cover ring-2 ring-[#EEF0FA]" />
              
                <div>
                  <div className="font-heading font-semibold text-sm text-[#0D1340]">
                    {t?.name}
                  </div>
                  <div className="text-xs text-[#9ea3ba]">
                    {t?.role} · {t?.company}
                  </div>
                </div>
              </div>
            </div>
          )}
        </div>
      </div>
    </section>);

}