"use client";

import { useEffect, useRef } from "react";
import Link from "next/link";
import Icon from "@/components/ui/AppIcon";

const floatingCards = [
  {
    icon: "CpuChipIcon" as const,
    title: "Sistema de Estoque",
    subtitle: "Controle total em tempo real",
    color: "#011363",
    delay: "0s",
  },
  {
    icon: "ArrowPathIcon" as const,
    title: "Automação de Processos",
    subtitle: "98% de eficiência operacional",
    color: "#2563EB",
    delay: "0.5s",
  },
  {
    icon: "ChartBarIcon" as const,
    title: "Relatórios Avançados",
    subtitle: "Dashboards em tempo real",
    color: "#0A1F8F",
    delay: "1s",
  },
];

export default function HeroSection() {
  const heroRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    const handleMouseMove = (e: MouseEvent) => {
      if (!heroRef.current) return;
      const { clientX, clientY } = e;
      const { innerWidth, innerHeight } = window;
      const x = (clientX / innerWidth - 0.5) * 20;
      const y = (clientY / innerHeight - 0.5) * 20;
      const orb = heroRef.current.querySelector(".hero-orb-main") as HTMLElement;
      if (orb) {
        orb.style.transform = `translate(${x}px, ${y}px)`;
      }
    };
    window.addEventListener("mousemove", handleMouseMove, { passive: true });
    return () => window.removeEventListener("mousemove", handleMouseMove);
  }, []);

  return (
    <section
      ref={heroRef}
      className="relative min-h-screen flex items-center overflow-hidden hero-gradient grid-bg pt-24"
    >
      {/* Background Orbs */}
      <div
        className="hero-orb hero-orb-main"
        style={{
          width: "600px",
          height: "600px",
          background: "radial-gradient(circle, rgba(1,19,99,0.08) 0%, transparent 70%)",
          top: "50%",
          left: "50%",
          transform: "translate(-50%, -50%)",
          transition: "transform 0.3s ease",
        }}
      />
      <div
        className="hero-orb"
        style={{
          width: "400px",
          height: "400px",
          background: "radial-gradient(circle, rgba(37,99,235,0.06) 0%, transparent 70%)",
          top: "20%",
          right: "10%",
        }}
      />
      <div
        className="hero-orb"
        style={{
          width: "300px",
          height: "300px",
          background: "radial-gradient(circle, rgba(1,19,99,0.05) 0%, transparent 70%)",
          bottom: "20%",
          left: "5%",
        }}
      />

      <div className="relative z-10 max-w-7xl mx-auto px-6 lg:px-8 w-full py-16 lg:py-24">
        <div className="grid lg:grid-cols-2 gap-16 items-center">
          {/* Left Column */}
          <div className="space-y-8">
            {/* Badge */}
            <div
              className="section-label animate-fade-in-up"
              style={{ animationDelay: "0.1s" }}
            >
              <Icon name="SparklesIcon" size={14} />
              Desenvolvimento Sob Medida
            </div>

            {/* Headline */}
            <div
              className="animate-fade-in-up"
              style={{ animationDelay: "0.2s" }}
            >
              <h1
                className="font-heading text-5xl lg:text-6xl xl:text-7xl font-extrabold leading-[1.05] tracking-tight text-[#0D1340]"
              >
                Sistemas que{" "}
                <span className="gradient-text">se adaptam</span>
                {" "}ao seu negócio.{" "}
                <span className="text-[#9ea3ba]">Não o contrário.</span>
              </h1>
            </div>

            {/* Subheadline */}
            <p
              className="text-lg text-[#6B7280] leading-relaxed max-w-xl font-body animate-fade-in-up"
              style={{ animationDelay: "0.35s" }}
            >
              A ADVOPACK desenvolve sistemas 100% personalizados para sua operação —
              com integrações via APIs, automação de processos e gestão completa de
              financeiro, estoque, equipes e muito mais.
            </p>

            {/* CTAs */}
            <div
              className="flex flex-col sm:flex-row gap-4 animate-fade-in-up"
              style={{ animationDelay: "0.45s" }}
            >
              <Link href="/homepage#contact" className="btn-primary text-sm">
                <Icon name="PlayIcon" size={16} />
                <span>Solicitar Demonstração</span>
              </Link>
              <Link href="/systems" className="btn-secondary text-sm">
                <span>Ver Sistemas</span>
                <Icon name="ArrowRightIcon" size={16} />
              </Link>
            </div>

            {/* Stats Row */}
            <div
              className="flex flex-wrap gap-8 pt-4 animate-fade-in-up"
              style={{ animationDelay: "0.55s" }}
            >
              {[
                { value: "120+", label: "Sistemas entregues" },
                { value: "98%", label: "Satisfação dos clientes" },
                { value: "24h", label: "Suporte especializado" },
              ].map((stat) => (
                <div key={stat.label}>
                  <div className="stat-number text-2xl font-extrabold font-heading">
                    {stat.value}
                  </div>
                  <div className="text-xs text-[#9ea3ba] font-medium mt-0.5">
                    {stat.label}
                  </div>
                </div>
              ))}
            </div>
          </div>

          {/* Right Column — Floating Cards */}
          <div className="relative hidden lg:flex items-center justify-center h-[500px]">
            {/* Central Ring Decoration */}
            <div
              className="absolute w-80 h-80 rounded-full border-2 border-dashed border-[#011363]/10 animate-spin-slow"
              style={{ animationDuration: "40s" }}
            />
            <div
              className="absolute w-56 h-56 rounded-full border border-[#2563EB]/10 animate-spin-slow"
              style={{ animationDuration: "25s", animationDirection: "reverse" }}
            />

            {/* Central Node */}
            <div className="relative z-10 glass-card rounded-2xl p-5 shadow-glow animate-pulse-glow">
              <div className="w-16 h-16 rounded-2xl bg-primary-gradient flex items-center justify-center">
                <Icon name="CpuChipIcon" size={32} className="text-white" />
              </div>
              <div className="mt-3">
                <div className="font-heading font-bold text-sm text-[#0D1340]">
                  ADVOPACK Core
                </div>
                <div className="text-xs text-[#9ea3ba] mt-0.5">Sistema Central</div>
              </div>
            </div>

            {/* Floating Cards */}
            {floatingCards.map((card, i) => {
              const positions = [
                { top: "5%", right: "0%" },
                { top: "65%", right: "5%" },
                { top: "35%", left: "0%" },
              ];
              return (
                <div
                  key={card.title}
                  className="absolute glass-card rounded-xl p-4 shadow-card animate-float"
                  style={{
                    ...positions[i],
                    animationDelay: card.delay,
                    animationDuration: `${5 + i}s`,
                    minWidth: "200px",
                  }}
                >
                  <div className="flex items-center gap-3">
                    <div
                      className="w-10 h-10 rounded-xl flex items-center justify-center"
                      style={{ background: `${card.color}15` }}
                    >
                      <Icon name={card.icon} size={20} className="text-[#011363]" />
                    </div>
                    <div>
                      <div className="font-heading font-semibold text-xs text-[#0D1340]">
                        {card.title}
                      </div>
                      <div className="text-[10px] text-[#9ea3ba] mt-0.5">
                        {card.subtitle}
                      </div>
                    </div>
                  </div>
                  {/* Live indicator */}
                  <div className="flex items-center gap-1.5 mt-3">
                    <span className="relative flex h-2 w-2">
                      <span
                        className="animate-ping absolute inline-flex h-full w-full rounded-full opacity-75"
                        style={{ background: card.color }}
                      />
                      <span
                        className="relative inline-flex rounded-full h-2 w-2"
                        style={{ background: card.color }}
                      />
                    </span>
                    <span className="text-[10px] text-[#9ea3ba] font-medium">
                      Ativo
                    </span>
                  </div>
                </div>
              );
            })}
          </div>
        </div>
      </div>

      {/* Bottom Wave */}
      <div className="absolute bottom-0 left-0 right-0">
        <svg
          viewBox="0 0 1440 80"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
          className="w-full"
        >
          <path
            d="M0 80L1440 80L1440 40C1200 80 960 0 720 20C480 40 240 80 0 40L0 80Z"
            fill="white"
          />
        </svg>
      </div>
    </section>
  );
}