"use client";

import { useEffect, useRef } from "react";
import Icon from "@/components/ui/AppIcon";
import AppImage from "@/components/ui/AppImage";

const benefits = [
{
  icon: "UserGroupIcon" as const,
  title: "Gestão de Equipes",
  desc: "Controle de funcionários, ponto eletrônico, permissões e hierarquias."
},
{
  icon: "CurrencyDollarIcon" as const,
  title: "Controle Financeiro",
  desc: "Contas a pagar e receber, fluxo de caixa, DRE e conciliação bancária."
},
{
  icon: "ArchiveBoxIcon" as const,
  title: "Gestão de Estoque",
  desc: "Controle de entrada e saída, alertas de ruptura e rastreabilidade."
},
{
  icon: "DocumentChartBarIcon" as const,
  title: "Relatórios Inteligentes",
  desc: "Dashboards personalizados com KPIs estratégicos para sua tomada de decisão."
},
{
  icon: "ShieldCheckIcon" as const,
  title: "Segurança Avançada",
  desc: "Criptografia, controle de acesso granular, logs de auditoria e backups automáticos."
},
{
  icon: "CloudArrowUpIcon" as const,
  title: "Cloud & On-Premise",
  desc: "Implantação flexível na nuvem ou na infraestrutura interna da sua empresa."
}];


export default function BenefitsSection() {
  const sectionRef = useRef<HTMLElement>(null);

  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            entry.target.querySelectorAll(".reveal-hidden").forEach((el) => {
              el.classList.remove("reveal-hidden");
            });
          }
        });
      },
      { threshold: 0.08 }
    );
    if (sectionRef.current) observer.observe(sectionRef.current);
    return () => observer.disconnect();
  }, []);

  return (
    <section ref={sectionRef} className="py-24 bg-[#F8F9FF]" id="benefits">
      <div className="max-w-7xl mx-auto px-6 lg:px-8">
        <div className="grid lg:grid-cols-2 gap-16 items-center">
          {/* Left: Image + Overlay Cards */}
          <div className="relative reveal reveal-hidden">
            <div className="relative rounded-3xl overflow-hidden shadow-card-hover">
              <AppImage
                src="https://img.rocket.new/generatedImages/rocket_gen_img_1682b282b-1766488897844.png"
                alt="Equipe de desenvolvimento ADVOPACK trabalhando em sistemas personalizados em escritório moderno"
                width={600}
                height={500}
                className="w-full h-[480px] object-cover" />
              
              {/* Overlay gradient */}
              <div className="absolute inset-0 bg-gradient-to-t from-[#011363]/60 via-transparent to-transparent" />
              {/* Bottom caption card */}
              <div className="absolute bottom-6 left-6 right-6 glass-card rounded-2xl p-4">
                <div className="flex items-center gap-3">
                  <div className="w-10 h-10 rounded-xl bg-primary-gradient flex items-center justify-center flex-shrink-0">
                    <Icon name="RocketLaunchIcon" size={20} className="text-white" />
                  </div>
                  <div>
                    <div className="font-heading font-bold text-sm text-[#0D1340]">
                      Entrega ágil e eficiente
                    </div>
                    <div className="text-xs text-[#6B7280] mt-0.5">
                      Da análise ao go-live em ciclos curtos
                    </div>
                  </div>
                </div>
              </div>
            </div>

            {/* Floating Metric Card */}
            <div
              className="absolute -top-6 -right-6 glass-card rounded-2xl p-4 shadow-card animate-float-delayed hidden lg:block"
              style={{ minWidth: "160px" }}>
              
              <div className="text-center">
                <div className="stat-number text-3xl font-extrabold font-heading">
                  120+
                </div>
                <div className="text-xs text-[#9ea3ba] mt-1 font-medium">
                  Sistemas entregues
                </div>
              </div>
            </div>
          </div>

          {/* Right: Benefits List */}
          <div className="space-y-6">
            <div className="reveal reveal-hidden">
              <div className="section-label inline-flex mb-4">
                <Icon name="PuzzlePieceIcon" size={14} />
                Funcionalidades
              </div>
              <h2 className="font-heading text-4xl font-bold text-[#0D1340] tracking-tight leading-tight">
                Tudo que sua empresa{" "}
                <span className="gradient-text">precisa, em um lugar só</span>
              </h2>
              <p className="text-[#6B7280] mt-4 leading-relaxed">
                Cada módulo é desenvolvido especificamente para a sua realidade.
                Sem funcionalidades desnecessárias, sem limitações artificiais.
              </p>
            </div>

            <div className="grid sm:grid-cols-2 gap-4">
              {benefits.map((b, i) =>
              <div
                key={b.title}
                className={`bg-white rounded-2xl p-4 border border-[#E2E5F0] hover:border-[#011363]/20 hover:shadow-card transition-all duration-300 reveal reveal-hidden reveal-delay-${i % 4 + 1}`}>
                
                  <div className="flex items-start gap-3">
                    <div className="w-9 h-9 rounded-xl bg-[#EEF0FA] flex items-center justify-center flex-shrink-0">
                      <Icon name={b.icon} size={18} className="text-[#011363]" />
                    </div>
                    <div>
                      <div className="font-heading font-semibold text-sm text-[#0D1340] mb-1">
                        {b.title}
                      </div>
                      <div className="text-xs text-[#6B7280] leading-relaxed">
                        {b.desc}
                      </div>
                    </div>
                  </div>
                </div>
              )}
            </div>
          </div>
        </div>
      </div>
    </section>);

}