<?php

session_start();
include 'conexao.php';

// Se já estiver logado, redireciona
if (isset($_SESSION['usuario'])) {
    $tipo = $_SESSION['usuario']['tipo'];
    header("Location: painel_$tipo.php");
    exit;
}

// Tentativa de login automático via cookie
if (!isset($_SESSION['usuario']) && isset($_COOKIE['login_token'])) {
    $token = $_COOKIE['login_token'];
    $sql = $pdo->prepare("SELECT * FROM usuarios WHERE token_login = ?");
    $sql->execute([$token]);
    $usuario = $sql->fetch();

    if ($usuario && $usuario['status'] === 'ATIVO') {
        $_SESSION['usuario'] = $usuario;
        header("Location: painel_{$usuario['tipo']}.php");
        exit;
    } else {
        // Token inválido, apaga cookie
        setcookie('login_token', '', time() - 3600, "/");
    }
}


$msgErro = '';
if ($_POST) {
    $nome = $_POST['nome'];
    $senha = $_POST['senha'];
    $lembrar = isset($_POST['lembrar']);

    $sql = $pdo->prepare("SELECT * FROM usuarios WHERE nome = ?");
    $sql->execute([$nome]);
    $usuario = $sql->fetch();

    if ($usuario && password_verify($senha, $usuario['senha'])) {
        if ($usuario['status'] === 'ATIVO') {
            $_SESSION['usuario'] = $usuario;

            // Se "lembrar-me" estiver marcado, cria cookie com token
            if ($lembrar) {
                $token = bin2hex(random_bytes(32)); // Token aleatório seguro

                // Define cookie para durar 30 dias
                setcookie('login_token', $token, time() + (86400 * 30), "/");

                // Atualiza o token no banco
                $stmt = $pdo->prepare("UPDATE usuarios SET token_login = ? WHERE id = ?");
                $stmt->execute([$token, $usuario['id']]);
            }

            header("Location: painel_{$usuario['tipo']}.php");
            exit;
        } else {
            $msgErro = "Seu usuário está inativo, consulte o responsável pelo sistema.";
        }
    } else {
        $msgErro = "Login inválido: nome ou senha incorretos.";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Chama ai - Login</title>
  <link rel="icon" type="image/png" href="img/favicon.png" />
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
  <style>
    * { box-sizing: border-box; padding: 0; margin: 0; }
    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #1e1e2f, #27293d);
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    .login-container {
      background: #2c2c3e;
      border-radius: 16px;
      padding: 40px;
      max-width: 400px;
      width: 90%;
      box-shadow: 0 0 30px rgba(0, 0, 0, 0.3);
      text-align: center;
      animation: fadeIn 1s ease-in-out;
    }
    .logo img {
      width: 180px;
      margin-bottom: 30px;
    }
    .form-group {
      position: relative;
      margin-bottom: 20px;
    }
    .form-group i {
      position: absolute;
      top: 12px;
      left: 15px;
      color: #888;
    }
    input[type="text"],
    input[type="password"] {
      width: 100%;
      padding: 12px 15px 12px 40px;
      background-color: #3b3b4d;
      border: none;
      border-radius: 10px;
      color: #fff;
      font-size: 15px;
      transition: 0.3s;
    }
    input:focus {
      outline: none;
      background-color: #44445a;
      transform: scale(1.02);
    }
    button {
      width: 100%;
      padding: 12px;
      background: linear-gradient(135deg, #3b7ddd, #326ccc);
      border: none;
      border-radius: 10px;
      color: #fff;
      font-weight: 600;
      font-size: 16px;
      cursor: pointer;
      transition: background 0.3s ease, transform 0.2s;
    }
    button:hover {
      transform: translateY(-2px);
      background: linear-gradient(135deg, #326ccc, #295cb6);
    }
    .error-msg {
      color: #ff4d4d;
      margin-bottom: 20px;
      font-size: 14px;
      background: #441f1f;
      padding: 10px;
      border-radius: 8px;
    }
    @keyframes fadeIn {
      from {opacity: 0; transform: translateY(-20px);}
      to {opacity: 1; transform: translateY(0);}
    }
    .remember {
      text-align: left;
      margin-bottom: 20px;
      color: #ccc;
      font-size: 14px;
    }
    .remember input {
      margin-right: 8px;
    }
  </style>
</head>
<body>

<div class="login-container">
  <div class="logo">
    <img src="img/logo_advopack.png" alt="Logo">
  </div>

  <?php if ($msgErro): ?>
    <div class="error-msg"><?= $msgErro ?></div>
  <?php endif; ?>

  <form method="post">
    <div class="form-group">
      <i class="fas fa-user"></i>
      <input type="text" name="nome" placeholder="Usuário" required>
    </div>
    <div class="form-group">
      <i class="fas fa-lock"></i>
      <input type="password" name="senha" placeholder="Senha" required>
    </div>

    <div class="remember">
      <label>
        <input type="checkbox" name="lembrar"> Lembrar-me
      </label>
    </div>

    <button type="submit">Entrar</button>
  </form>
</div>

</body>
</html>
