<?php 

include 'autentica.php';
if ($usuario['tipo'] != 'restaurante') exit('Acesso negado');
include 'conexao.php';


$stmt = $pdo->query("SELECT * FROM alertas WHERE ativo = 1 ORDER BY data_criacao DESC LIMIT 1");
$alerta = $stmt->fetch(PDO::FETCH_ASSOC);




if ($alerta):
?>
<div class="alert alert-warning alert-dismissible fade show" role="alert">
        <strong><?= htmlspecialchars($alerta['titulo']) ?>:</strong>
        <?= nl2br(htmlspecialchars($alerta['mensagem'])) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>

<?php
endif;


?>
<!DOCTYPE html>

<html lang="pt-br">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="manifest" href="https://progressier.app/MAlTMYQAYjwc0m0Bk2SX/progressier.json"/><script defer src="https://progressier.app/MAlTMYQAYjwc0m0Bk2SX/script.js"></script>  
    <link rel="manifest" href="/manifest.json">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <meta charset="UTF-8">
   <link rel="icon" type="image/png" href="img/favicon.png" />
  <link rel="shortcut icon" href="img/favicon.png" type="image/png" />
  <title>Painel Restaurante</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />

  <!-- Painel do Restaurante -->
<div class="painel-container">
    
    <div class="d-flex justify-content-center mb-3">
    <img src="img/painelrest.png" alt="Logo do Restaurante" class="logo-restaurante" style="max-width: 120px; height: auto;">
  </div>
  
  <h2 class="painel-titulo"><i class="fas fa-utensils"></i> Painel  <?php echo $_SESSION['usuario']['nome']; ?></h2>


<h5 class="text-muted mt-1">
   <!-- <?php echo $_SESSION['usuario']['nome']; ?> -->
  </h5>

  <nav class="painel-links">
    <a href="#" id="link-entregas"><i class="fas fa-box"></i> Minhas Entregas</a>
    <a href="#" id="link-filtros" class="btn btn-outline-light"> <i class="fas fa-search"></i> Buscar Entregas</a>
    <!-- <a href="#" id="link-chat" class="btn btn-outline-light" data-bs-toggle="modal" data-bs-target="#chatModal">
  <i class="fas fa-comments"></i> Chat *em construção*
</a>
  <a href="#" id="link-importar"><i class="fas fa-file-export"></i> Exportar PDF</a> -->
    <a href="javascript:void(0);" id="link-editar-perfil">
  <i class="fas fa-cog"></i> Editar Perfil
</a>

    
    <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Sair</a>
  </nav>
</div>


<style>
    /* Estilos gerais para modais */
.modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5); /* Fundo sombreado */
    z-index: 2000;
    overflow-y: auto;
    padding-top: 50px;
}

/* Modal Header */
.modal-header {
    display: flex;
    justify-content: space-between;
    padding: 16px;
    background-color: #128C7E;
    color: white;
    font-size: 18px;
    border-bottom: 1px solid #ccc;
}

.modal-header .btn-close {
    background: transparent;
    border: none;
    font-size: 24px;
    color: white;
    cursor: pointer;
}

.modal-header .btn-close:hover {
    color: #dcdcdc;
}

/* Modal Content */
.modal-content {
    background-color: #ffffff;
    border-radius: 8px;
    width: 100%;
    max-width: 400px;
    margin: 0 auto;
    overflow: hidden;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

/* Modal Body */
.modal-body {
    padding: 20px;
    overflow-y: auto;
    max-height: 400px; /* Limitar altura da área de mensagens */
    font-family: 'Arial', sans-serif;
}

#lista-conversas {
    max-height: 300px;
    overflow-y: auto;
}

#historico-conversa {
    max-height: 300px;
    overflow-y: auto;
}

.mensagem {
    padding: 8px;
    border-radius: 10px;
    margin-bottom: 10px;
    display: flex;
    flex-direction: column;
}

.mensagem-enviada {
    background-color: #DCF8C6;
    align-self: flex-end;
    text-align: right;
}

.mensagem-recebida {
    background-color: #FFFFFF;
    align-self: flex-start;
}

.nome-remetente {
    font-weight: bold;
    font-size: 12px;
    margin-bottom: 5px;
}

.conteudo-mensagem {
    font-size: 14px;
    word-wrap: break-word;
}

.data-envio {
    font-size: 10px;
    color: #555;
    margin-top: 5px;
}

/* Footer for modal - Enviar mensagem */
.modal-footer {
    display: flex;
    justify-content: space-between;
    padding: 10px;
    background-color: #f1f1f1;
    border-top: 1px solid #ccc;
}

.modal-footer input[type="text"] {
    width: 80%;
    padding: 8px;
    font-size: 14px;
    border: 1px solid #ccc;
    border-radius: 20px;
    outline: none;
}

.modal-footer input[type="text"]:focus {
    border-color: #128C7E;
}

.modal-footer button {
    background-color: #128C7E;
    color: white;
    padding: 8px 16px;
    border: none;
    border-radius: 20px;
    cursor: pointer;
    font-size: 14px;
}

.modal-footer button:hover {
    background-color: #075E54;
}

/* Botão para abrir nova conversa */
#nova-conversa-btn {
    background-color: #25D366;
    color: white;
    padding: 8px 16px;
    border: none;
    border-radius: 20px;
    display: block;
    text-align: center;
    margin: 10px auto;
    cursor: pointer;
}

#nova-conversa-btn:hover {
    background-color: #128C7E;
}

/* Modal para Nova Conversa - Ajustes */
#usuarioSelect {
    width: 100%;
    padding: 8px;
    font-size: 14px;
    border: 1px solid #ccc;
    border-radius: 8px;
    margin-bottom: 10px;
}

#novaMensagem {
    width: 100%;
    padding: 8px;
    font-size: 14px;
    border: 1px solid #ccc;
    border-radius: 8px;
    margin-bottom: 10px;
    resize: none;
}

</style>

<!-- Modal - Lista de Conversas -->
<div class="modal fade" id="chatModal" tabindex="-1" aria-labelledby="chatModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="chatModalLabel">Conversas</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <!-- Botão Nova Conversa -->
            <a href="#" id="nova-conversa-btn" class="btn btn-outline-success" data-bs-toggle="modal" data-bs-target="#novaConversaModal">
                Nova Conversa
            </a>
            <div class="modal-body" id="lista-conversas">
                <!-- A lista de conversas será carregada aqui via AJAX -->
            </div>
        </div>
    </div>
</div>



<!-- Modal - Conversa Específica -->
<div class="modal fade" id="conversaModal" tabindex="-1" aria-labelledby="conversaModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="conversaModalLabel">Histórico de Conversa</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="historico-conversa">
                <!-- O histórico da conversa será carregado aqui via AJAX -->
            </div>
            <div class="modal-footer">
                <input type="text" id="nova-mensagem" class="form-control" placeholder="Digite sua mensagem...">
                <button type="button" class="btn btn-primary" id="enviar-mensagem">Enviar</button>
            </div>
        </div>
    </div>
</div>




<!-- Modal - Nova Conversa -->
<div class="modal fade" id="novaConversaModal" tabindex="-1" aria-labelledby="novaConversaModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="novaConversaModalLabel">Iniciar Nova Conversa</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="usuarioSelect" class="form-label">Escolha o Usuário</label>
                    <select id="usuarioSelect" class="form-select">
                        <!-- Usuários serão carregados aqui via AJAX -->
                    </select>
                </div>
                <div class="mb-3">
                    <label for="novaMensagem" class="form-label">Sua Mensagem</label>
                    <textarea id="novaMensagem" class="form-control" rows="3"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="enviarNovaMensagem">Enviar</button>
            </div>
        </div>
    </div>
</div>

<script>
   document.addEventListener("DOMContentLoaded", function () {
    // Carregar os usuários para o select de nova conversa
    function carregarUsuarios() {
        fetch('chat/carregar_usuarios.php')
            .then(response => response.json())
            .then(data => {
                let usuarioSelect = document.getElementById('usuarioSelect');
                usuarioSelect.innerHTML = '<option value="" disabled selected>Escolha um usuário</option>';
                data.forEach(usuario => {
                    let option = document.createElement('option');
                    option.value = usuario.id;
                    option.textContent = usuario.nome;
                    usuarioSelect.appendChild(option);
                });
            });
    }

    // Obter o ID do usuário logado com segurança
    let usuario_id_logado = <?php echo isset($_SESSION['usuario']['id']) ? $_SESSION['usuario']['id'] : 'null'; ?>;  // Garantir que o ID do usuário logado seja passado

    // Verificar se o usuário logado existe
    if (usuario_id_logado === null) {
        console.error("Erro: ID do usuário logado não encontrado.");
        return;  // Impede a execução do código caso o ID do usuário logado não seja encontrado
    }

    // Enviar a nova conversa
    document.getElementById('enviarNovaMensagem').onclick = function () {
        let usuario_id = document.getElementById('usuarioSelect').value;
        let mensagem = document.getElementById('novaMensagem').value;

        // Verificar se ambos os campos estão preenchidos
        if (!usuario_id || !mensagem) {
            alert('Por favor, selecione um usuário e escreva uma mensagem.');
            return;
        }

        // Criar a conversa no banco
        fetch('chat/criar_conversa.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ 
                usuario_id_destino: usuario_id, 
                mensagem: mensagem, 
                usuario_id_logado: usuario_id_logado  // Passar o ID do usuário logado
            })  
        })
        .then(response => response.text())
        .then(data => {
            alert(data); // Exibir mensagem de sucesso
            // Fechar modal
            $('#novaConversaModal').modal('hide');
        });
    }

    carregarUsuarios();
});


document.addEventListener("DOMContentLoaded", function () {
    // Variável global para armazenar o ID da conversa
    let conversa_id_atual;

    // Carregar as conversas
    function carregarConversas() {
        fetch('chat/listar_conversas.php')
            .then(response => response.json())
            .then(data => {
                let listaConversas = document.getElementById('lista-conversas');
                listaConversas.innerHTML = '';  // Limpar a lista existente
                if (data.length > 0) {
                    data.forEach(conversa => {
                        let item = document.createElement('button');
                        item.classList.add('btn', 'btn-light', 'w-100', 'my-2');
                        item.textContent = conversa.usuario_comum + ' - ' + conversa.ultimo_mensagem;

                        // Passar o conversa_id para a função carregarHistorico
                        item.onclick = () => {
                            console.log('Conversa ID:', conversa.id);  // Verifique se o ID da conversa está correto
                            carregarHistorico(conversa.id);  // Passando o ID da conversa
                        };

                        listaConversas.appendChild(item);
                    });
                } else {
                    listaConversas.innerHTML = 'Você ainda não tem conversas.';
                }
            })
            .catch(error => {
                console.error("Erro ao carregar as conversas:", error);
            });
    }

    // Carregar o histórico da conversa
    function carregarHistorico(conversa_id) {
        conversa_id_atual = conversa_id;  // Armazena o ID da conversa globalmente
        fetch('chat/exibir_conversa.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ conversa_id: conversa_id })  // Passando o ID da conversa
        })
        .then(response => response.json())
        .then(data => {
            console.log("Mensagens carregadas:", data);  // Verificar as mensagens carregadas
            let historico = document.getElementById('historico-conversa');
            historico.innerHTML = '';  // Limpar o histórico anterior

            if (Array.isArray(data) && data.length > 0) {
                data.forEach(mensagem => {
                    let divMensagem = document.createElement('div');
                    divMensagem.classList.add('mensagem');

                    let isUsuarioLogado = mensagem.nome === 'Usuário Logado';  // Ajuste conforme seu critério

                    // Aplicar estilo baseado no remetente
                    divMensagem.classList.add(isUsuarioLogado ? 'mensagem-enviada' : 'mensagem-recebida');

                    divMensagem.innerHTML = `
                        <div class="nome-remetente">${mensagem.nome}</div>
                        <div class="conteudo-mensagem">${mensagem.mensagem}</div>
                        <div class="data-envio">${new Date(mensagem.data_envio).toLocaleString()}</div>
                    `;
                    historico.appendChild(divMensagem);
                });
            } else {
                historico.innerHTML = 'Nenhuma mensagem encontrada.';
            }

            $('#conversaModal').modal('show');
        })
        .catch(error => {
            console.error('Erro ao carregar o histórico da conversa:', error);
        });
    }

    // Enviar nova mensagem
    document.getElementById('enviar-mensagem').onclick = function () {
        let mensagem = document.getElementById('nova-mensagem').value;

        if (!mensagem) {
            alert('Digite uma mensagem.');
            return;
        }

        fetch('chat/enviar_mensagem.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                conversa_id: conversa_id_atual,  // Usa a variável global com o ID da conversa
                mensagem: mensagem
            })
        })
        .then(response => response.text())
        .then(data => {
            console.log(data);  // Log de depuração
            document.getElementById('nova-mensagem').value = '';  // Limpar o campo de mensagem
            carregarHistorico(conversa_id_atual); // Atualizar o histórico com a nova mensagem
        })
        .catch(error => {
            console.error('Erro ao enviar a mensagem:', error);
        });
    }

    // Carregar as conversas ao abrir a página
    carregarConversas();

    // Atualizar a lista de conversas a cada 5 segundos (5000ms)
    setInterval(carregarConversas, 5000);  // Adiciona o intervalo para atualização em tempo real
});







</script>
<style>




    .modal .modal-dialog {
    max-width: 600px;
}

.modal-body {
    max-height: 400px;
    overflow-y: auto;
}

.modal-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

#nova-mensagem {
    width: 80%;
}

#enviar-mensagem {
    width: 18%;
}

</style>



<style>
/* estilo modal entregas */
#modal-entregas {
  display: none; /* oculto por padrão */
  position: fixed;
  z-index: 1040; /* menor que #modal-nova-entrega */
  left: 0; 
  top: 0;
  width: 100%; 
  height: 100%;
  overflow: auto;
  background-color: rgba(0,0,0,0.4); /* fundo semi-transparente mais leve */
  font-family: 'Segoe UI', sans-serif;
}

@media (max-width: 480px) {
  .painel-container {
    margin: 20px 10px;
    padding: 20px 15px;
    
  }

  .painel-titulo {
    font-size: 18px;
  }

  .painel-links a {
    font-size: 14px;
    padding: 12px;
  }

  .logo-restaurante {
    max-width: 80px;
  }
}


body {
  background: #dbd9d9; /* ou qualquer cor desejada */
  margin: 0;
  padding: 0;
  font-family: 'Segoe UI', sans-serif;
}


.logo-restaurante {
  border-radius: 10px;
  box-shadow: 0 4px 10px rgba(0, 0, 0, 0.15);
  display: block;
  margin: 0 auto 20px;
  max-width: 100px;
}

.painel-container {
  max-width: 380px;
  margin: 40px auto;
  background: #f9f9f9;
  padding: 25px 20px;
  border-radius: 14px;
  box-shadow: 0 8px 24px rgba(0, 0, 0, 0.12);
  font-family: 'Segoe UI', sans-serif;
}

.painel-titulo {
  text-align: center;
  color: #2c2c2c;
  font-size: 22px;
  font-weight: bold;
  margin-bottom: 25px;
}

.painel-links {
  display: flex;
  flex-direction: column;
  gap: 14px;
}

.painel-links a {
  display: flex;
  align-items: center;
  padding: 14px;
  background: #ffffff;
  border-radius: 10px;
  color: #333;
  text-decoration: none;
  transition: background 0.3s ease, transform 0.2s ease;
  font-size: 16px;
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
}

.painel-links a i {
  margin-right: 12px;
  color: #4a4a4a;
  min-width: 20px;
  text-align: center;
  font-size: 18px;
}

.painel-links a:hover {
  background: #f0f0f0;
  color: #000;
  transform: translateY(-2px);
}
</style>



<!-- STILO MODAL ENTREGAS -->
<style>



.modal-content {
  background-color: #343a40; /* Fundo escuro */
  color: #fff;               /* Texto branco */
  margin: auto;
  padding: 20px;
  border-radius: 10px;
  width: 90%;
  max-width: 800px;
  box-shadow: 0 5px 15px rgba(0,0,0,0.5);
}


.close {
  color: #aaa;
  float: right;
  font-size: 24px;
  font-weight: bold;
  cursor: pointer;
}

.btn-nova-entrega {
  background-color: #28a745;
  color: white;
  border: none;
  padding: 10px 14px;
  border-radius: 6px;
  font-weight: bold;
  margin-bottom: 15px;
  cursor: pointer;
}

#lista-entregas table {
  width: 100%;
  border-collapse: collapse;
  margin-top: 10px;
}

#lista-entregas th, #lista-entregas td {
  padding: 10px;
  border-bottom: 1px solid #ddd;
  text-align: left;
}

</style>


<!-- MODAIs --->

<style>
  #lista-entregas {
    max-height: 400px;
    overflow-y: auto;
    padding-right: 8px;
    box-sizing: border-box;
  }
</style>


<!-- Modal Minhas Entregas -->
<div id="modal-entregas" class="modal">
  <div class="modal-content">
    <span class="close" id="fechar-entregas">&times;</span>
    <h2>Minhas Entregas</h2>
    <button class="btn-nova-entrega">+ NOVA ENTREGA</button>
    <div id="lista-entregas">
      <!-- Lista carregada via AJAX -->
    </div>
  </div>
</div>



<!-- Modal Nova Entrega -->


<div id="modal-nova-entrega" role="dialog" aria-modal="true" aria-labelledby="titulo-nova-entrega" aria-describedby="desc-nova-entrega">
  <div class="modal-content">
    <button class="close" id="fechar-nova-entrega" aria-label="Fechar modal">&times;</button>
    <h2 id="titulo-nova-entrega">Nova Entrega</h2>

    <form id="form-nova-entrega" aria-describedby="desc-nova-entrega">
      <label for="input-destino">Destino:</label>
      <input type="text" id="input-destino" name="destino" required autocomplete="off" placeholder="Informe o destino">

      <label for="select-bairro">Bairro:</label>
      <select name="bairro_id" id="select-bairro" required>
        <option value="" disabled selected>Selecione o bairro</option>
        </select>

      <label for="input-horario-coleta">Disponível para coleta em:</label>
      <input type="number" id="input-horario-coleta" name="horario_coleta" required placeholder="Minutos (ex: 10)" min="1">
      
      <button type="submit" class="btn-nova-entrega">Cadastrar Entrega</button>
    </form>

    <div id="resposta-entrega" role="alert" aria-live="polite"></div>
  </div>
</div>


<style>

@media (max-width: 480px) {
  #modal-nova-entrega .modal-content {
    width: 95%;
    padding: 15px;
  }

  #modal-entregas .modal-content {
    width: 95%;
    padding: 15px;
  }

  .btn-nova-entrega {
    font-size: 14px;
    padding: 8px;
  }

  #modal-nova-entrega input,
  #modal-nova-entrega select {
    font-size: 14px;
  }
}



#modal-nova-entrega .modal-content {
  max-height: 90vh;  /* Limita a altura da modal à 90% da tela */
  overflow-y: auto;  /* Habilita rolagem se necessário */
  padding-right: 10px; /* Espaço para barra de rolagem */
}



  /* Modal container - centralizado, fundo semi-transparente */
  #modal-nova-entrega {
    display: none; /* oculto por padrão */
    position: fixed;
    z-index: 1000;
    left: 0; top: 0;
    width: 100%; height: 100%;
    overflow: auto;
    background-color: rgba(0,0,0,0.5);
    font-family: Arial, sans-serif;
  }

  /* Conteúdo da modal */
  #modal-nova-entrega .modal-content {
    background-color: #fff;
    margin: 5% auto;
    padding: 20px 30px;
    border-radius: 8px;
    max-width: 400px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.25);
    position: relative;
  }

  /* Botão fechar */
  #modal-nova-entrega .close {
    position: absolute;
    right: 15px;
    top: 15px;
    font-size: 28px;
    font-weight: bold;
    color: #666;
    cursor: pointer;
    border: none;
    background: transparent;
  }
  #modal-nova-entrega .close:hover,
  #modal-nova-entrega .close:focus {
    color: #000;
    outline: none;
  }

  /* Título */
  #modal-nova-entrega h2 {
    margin-top: 0;
    margin-bottom: 20px;
    font-weight: 600;
    color: #333;
    text-align: center;
  }

  /* Formulário */
  #modal-nova-entrega form {
    display: flex;
    flex-direction: column;
    gap: 15px;
  }

  #modal-nova-entrega label {
    font-weight: 600;
    color: #555;
  }

  #modal-nova-entrega input[type="text"],
  #modal-nova-entrega select {
    padding: 8px 12px;
    font-size: 16px;
    border: 1.5px solid #ccc;
    border-radius: 5px;
    transition: border-color 0.3s ease;
  }
  #modal-nova-entrega input[type="text"]:focus,
  #modal-nova-entrega select:focus {
    border-color: #007bff;
    outline: none;
  }

  /* Botão submit */
  #modal-nova-entrega button.btn-nova-entrega {
    background-color: #007bff;
    color: white;
    font-weight: 600;
    padding: 10px 0;
    border: none;
    border-radius: 6px;
    font-size: 16px;
    cursor: pointer;
    transition: background-color 0.3s ease;
  }
  #modal-nova-entrega button.btn-nova-entrega:hover,
  #modal-nova-entrega button.btn-nova-entrega:focus {
    background-color: #0056b3;
    outline: none;
  }

  /* Feedback resposta */
  #resposta-entrega {
    margin-top: 15px;
    font-size: 14px;
    min-height: 20px;
    color: #28a745; /* verde para sucesso */
    
    
  }
  
  #modal-nova-entrega {
  z-index: 1050; /* valor alto para ficar acima de tudo */
}

#resultadoBuscasEntregas {
  max-height: 400px; /* ou o valor que desejar */
  overflow-y: auto;
  padding-right: 10px; /* espaço para a barra de rolagem */
}


</style>

<!--- script modal ENTREGAS -->

<script>
document.getElementById("link-entregas").addEventListener("click", function (e) {
  e.preventDefault();
  document.getElementById("modal-entregas").style.display = "block";

  carregarEntregas(); // Carrega imediatamente ao abrir
  iniciarAtualizacao(); // Inicia o intervalo de atualização
});

document.getElementById("fechar-entregas").addEventListener("click", function () {
  document.getElementById("modal-entregas").style.display = "none";

  pararAtualizacao(); // Para quando fecha
});

let intervaloAtualizacao;

function carregarEntregas() {
  fetch("carregar_entregasRES.php")
    .then(response => response.text())
    .then(data => {
      document.getElementById("lista-entregas").innerHTML = data;
    });
}

function iniciarAtualizacao() {
  intervaloAtualizacao = setInterval(carregarEntregas, 5000); // 5000 ms = 5 segundos
}

function pararAtualizacao() {
  clearInterval(intervaloAtualizacao);
}
</script>


<script>
document.querySelector(".btn-nova-entrega").addEventListener("click", function () {
  document.getElementById("modal-nova-entrega").style.display = "block";

  // buscar bairros apenas uma vez
  fetch("buscar_bairrosRES.php")
    .then(response => response.text())
    .then(data => {
      document.getElementById("select-bairro").innerHTML = data;
    })
    .catch(() => {
      Swal.fire({
        icon: 'error',
        title: 'Erro',
        text: 'Não foi possível carregar os bairros.',
        timer: 2500,
        showConfirmButton: false
      });
    });
});

// fechar a modal
document.getElementById("fechar-nova-entrega").addEventListener("click", function () {
  document.getElementById("modal-nova-entrega").style.display = "none";
});

document.getElementById("form-nova-entrega").addEventListener("submit", function (e) {
  e.preventDefault();

  const formData = new FormData(this);

  // pega o valor dos minutos diretamente
  const minutosDisponivel = formData.get('horario_coleta');
  formData.append('disponivel_em', minutosDisponivel);
  formData.delete('horario_coleta');

  fetch("cadastrar_entrega.php", {
    method: "POST",
    body: formData
  })
  .then(res => res.text())
  .then(resposta => {
    if (resposta.toLowerCase().includes("sucesso")) {
      Swal.fire({
        icon: 'success',
        title: 'Entrega cadastrada!',
        text: resposta,
        timer: 200000,
        showConfirmButton: false,
        didOpen: () => {
          // garante que o swal fique sempre acima da modal
          document.querySelector(".swal2-container").style.zIndex = "20000";
        }
      });

      setTimeout(() => {
        // fecha modal
        document.getElementById("modal-nova-entrega").style.display = "none";

        // recarrega a página inteira
        location.reload();
      }, 2000);

    } else {
      Swal.fire({
        icon: 'error',
        title: 'Erro',
        text: resposta,
        timer: 2500,
        showConfirmButton: false,
        didOpen: () => {
          document.querySelector(".swal2-container").style.zIndex = "20000";
        }
      });
    }
  })
  .catch(() => {
    Swal.fire({
      icon: 'error',
      title: 'Erro',
      text: 'Não foi possível cadastrar a entrega.',
      timer: 2500,
      showConfirmButton: false,
      didOpen: () => {
        document.querySelector(".swal2-container").style.zIndex = "20000";
      }
    });
  });
});
</script>






<!-- MODAL BUSCAR ENTREGAS -->
<div class="modal fade" id="modalBuscarEntregas" tabindex="-1" aria-labelledby="modalBuscarEntregasLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content bg-dark text-white">
      
      <div class="modal-header">
        <h5 class="modal-title" id="modalBuscarEntregasLabel">Buscar Entregas por Período</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      
      <div class="modal-body">
        <!-- Formulário de Filtro -->
        <form id="formFiltroEntregas" class="row g-3 mb-4">
          <div class="col-md-5">
            <label for="data_inicio" class="form-label">Data Início:</label>
            <input type="date" id="data_inicio" name="data_inicio" class="form-control" required>
          </div>
          <div class="col-md-5">
            <label for="data_fim" class="form-label">Data Fim:</label>
            <input type="date" id="data_fim" name="data_fim" class="form-control" required>
          </div>
          <div class="col-md-2 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">Filtrar</button>
            
          </div>
        </form>
        
        

        <!-- Resultados da busca -->
        <div id="resultadoBuscasEntregas">
          <!-- As entregas filtradas aparecerão aqui via AJAX -->
        </div>
        
        <!-- Botão Gerar PDF -->
<div class="text-end mt-3" id="btnGerarPDFContainer" style="display: none;">
  <form id="formGerarPDF" method="POST" action="gerar_pdf_entregasRES.php" target="_blank">
    <input type="hidden" name="data_inicio" id="pdf_data_inicio">
    <input type="hidden" name="data_fim" id="pdf_data_fim">
    <button type="submit" class="btn btn-success">
      <i class="fas fa-file-pdf me-2"></i>Gerar PDF
    </button>
  </form>
</div>
        
      </div>
    </div>
  </div>
</div>



<!-- jQuery (necessário para o AJAX funcionar) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Bootstrap Bundle JS (inclui Popper para modais) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
  $(document).ready(function () {
    // Abrir modal ao clicar no link
    $('#link-filtros').click(function (e) {
      e.preventDefault();
      $('#modalBuscarEntregas').modal('show');
      $('#resultadoBuscasEntregas').html(''); // limpa resultado anterior
    });

    // Submissão do filtro via AJAX
    $('#formFiltroEntregas').submit(function (e) {
      e.preventDefault();

      // Opcional: desabilitar botão para evitar múltiplos cliques
      const $btn = $(this).find('button[type="submit"]');
      $btn.prop('disabled', true).text('Carregando...');

      $.ajax({
        url: 'buscar_entregas_filtroRES.php', // Verifique se está correto!
        method: 'POST',
        data: $(this).serialize(),
        success: function (resposta) {
          $('#resultadoBuscasEntregas').html(resposta);
        },
        error: function () {
          $('#resultadoBuscasEntregas').html('<div class="alert alert-danger">Erro ao carregar entregas.</div>');
        },
        complete: function () {
          $btn.prop('disabled', false).text('Filtrar');
        }
      });
    });
  });
  
  
  $('#formFiltroEntregas').submit(function (e) {
  e.preventDefault();

  const $btn = $(this).find('button[type="submit"]');
  $btn.prop('disabled', true).text('Carregando...');

  const data_inicio = $('#data_inicio').val();
  const data_fim = $('#data_fim').val();

  $.ajax({
    url: 'buscar_entregas_filtroRES.php',
    method: 'POST',
    data: $(this).serialize(),
    success: function (resposta) {
      $('#resultadoBuscasEntregas').html(resposta);

      // Preenche campos ocultos e mostra botão PDF
      $('#pdf_data_inicio').val(data_inicio);
      $('#pdf_data_fim').val(data_fim);
      $('#btnGerarPDFContainer').show();
    },
    error: function () {
      $('#resultadoBuscasEntregas').html('<div class="alert alert-danger">Erro ao carregar entregas.</div>');
      $('#btnGerarPDFContainer').hide();
    },
    complete: function () {
      $btn.prop('disabled', false).text('Filtrar');
    }
  });
});

  
</script>


<!-- Modal Editar Perfil do Restaurante -->
<div class="modal fade" id="modalEditarPerfil" tabindex="-1" aria-labelledby="modalEditarPerfilLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formEditarPerfil" method="POST">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Editar Perfil</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
        </div>
        <div class="modal-body">

          <div class="mb-3">
            <label for="nome" class="form-label">Nome</label>
            <input type="text" class="form-control" name="nome" id="nome" required>
          </div>

          <div class="mb-3">
            <label for="email" class="form-label">E-mail</label>
            <input type="email" class="form-control" name="email" id="email" required>
          </div>

          <div class="mb-3">
            <label for="senha" class="form-label">Nova Senha</label>
            <input type="password" class="form-control" name="senha" id="senha" placeholder="Deixe em branco para manter a atual">
          </div>

        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Salvar Alterações</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- script EDITAR PERFIL -->
<script>
document.getElementById('link-editar-perfil').addEventListener('click', function () {
  // aqui você pode pegar os dados de variáveis globais, de dataset no link ou via fetch
  const nome = "<?= $usuario['nome'] ?>";
  const email = "<?= $usuario['email'] ?>";

  document.getElementById('nome').value = nome;
  document.getElementById('email').value = email;
  document.getElementById('senha').value = ""; // sempre vazio no início

  const modalPerfil = new bootstrap.Modal(document.getElementById('modalEditarPerfil'));
  modalPerfil.show();
});
</script>





<script>
document.getElementById('formEditarPerfil').addEventListener('submit', function(e) {
  e.preventDefault();

  const form = e.target;
  const formData = new FormData(form);

  fetch('editar_perfil_restaurante.php', {
    method: 'POST',
    body: formData
  })
  .then(res => res.text())
  .then(data => {
    alert(data);
    const modal = bootstrap.Modal.getInstance(document.getElementById('modalEditarPerfil'));
    modal.hide();
    location.reload(); // Atualiza a página para refletir alterações no topo
  })
  .catch(err => {
    alert('Erro ao atualizar perfil.');
    console.error(err);
  });
});
</script>

<!-- Rodapé moderno transparente e com contraste ajustado -->
<style>
  .footer-modern {
    position: fixed;
    bottom: 0;
    width: 100%;
    background: transparent; /* Fundo removido */
    color: #212529; /* Texto escuro para melhor contraste em fundo claro */
    text-align: center;
    padding: 14px 10px;
    font-size: 14px;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    z-index: 9999;
    box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.05); /* Sombra leve, quase imperceptível */
  }

  .footer-modern a {
    color: #0056b3; /* Azul escuro para melhor contraste */
    font-weight: 600;
    text-decoration: none;
    transition: color 0.3s ease;
  }

  .footer-modern a:hover {
    color: #003974;
    text-decoration: underline;
  }

  .footer-modern i {
    margin-right: 6px;
    color: #f0ad4e; /* Tom mais sóbrio do amarelo */
  }

  @media (max-width: 600px) {
    .footer-modern {
      font-size: 13px;
      padding: 10px 5px;
    }
  }
</style>

<footer class="footer-modern">
  <i class="fas fa-shield-alt"></i>
  &copy; 2025 <a href="https://advopack.net" target="_blank">ADVOPACK</a> - Todos os direitos reservados.
</footer>

<!-- Font Awesome CDN para os ícones -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">



<!-- Botão flutuante 
<div class="theme-selector-button" onclick="toggleThemeMenu()">🎨</div>-->

<!-- Menu de seleção de tema -->
<div class="theme-selector-menu" id="themeMenu">
  <div onclick="setTheme('claro')">🌞 Claro</div>
  <div onclick="setTheme('escuro')">🌙 Escuro</div>
  <div onclick="setTheme('cinza')">⚙️ Cinza</div>
</div>


<style>
/* Botão flutuante de tema */
.theme-selector-button {
  position: fixed;
  top: 20px;
  left: 20px;
  background: #444;
  color: #fff;
  border-radius: 50%;
  padding: 12px 14px;
  cursor: pointer;
  box-shadow: 0 2px 10px rgba(0,0,0,0.25);
  font-size: 18px;
  z-index: 100000;
}

/* Menu de seleção de temas */
.theme-selector-menu {
  position: fixed;
  top: 70px;
  left: 20px;
  background: #fff;
  border-radius: 8px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.2);
  overflow: hidden;
  display: none;
  z-index: 100000;
}

.theme-selector-menu div {
  padding: 12px 16px;
  cursor: pointer;
  border-bottom: 1px solid #eee;
  font-family: Arial, sans-serif;
  font-size: 15px;
}

.theme-selector-menu div:hover {
  background-color: #f0f0f0;
}

/* Temas aplicáveis ao body */
body.tema-claro {
  background: #f5f5f5;
  color: #222;
}

body.tema-escuro {
  background: #121212;
  color: #f1f1f1;
}

body.tema-cinza {
  background: #c1c1c1;
  color: #1a1a1a;
}

/* Exemplo para alterar a modal com o tema escuro */
body.tema-escuro #modal-nova-entrega .modal-content {
  background-color: #2b2b2b;
  color: #f1f1f1;
}

</style>

<script>
function toggleThemeMenu() {
  const menu = document.getElementById("themeMenu");
  menu.style.display = menu.style.display === "block" ? "none" : "block";
}

function setTheme(theme) {
  document.body.className = ''; // remove classes anteriores
  document.body.classList.add(`tema-${theme}`);
  localStorage.setItem('temaSelecionado', theme);
  document.getElementById("themeMenu").style.display = "none";
}

// Aplica tema salvo ao carregar
window.onload = () => {
  const tema = localStorage.getItem('temaSelecionado');
  if (tema) {
    document.body.classList.add(`tema-${tema}`);
  }
};
</script>


