<?php



include 'autentica.php';
if ($usuario['tipo'] != 'motoboy') exit('Acesso negado');
?>






<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="manifest" href="https://progressier.app/MAlTMYQAYjwc0m0Bk2SX/progressier.json"/><script defer src="https://progressier.app/MAlTMYQAYjwc0m0Bk2SX/script.js"></script>   
    <link rel="manifest" href="/manifest.json">
  <link rel="icon" type="image/png" href="img/favicon.png" />
  <link rel="shortcut icon" href="img/favicon.png" type="image/png" />
  <title>Painel Motoboy</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">




  <style>
  
  
  
  .filtros {
  display: flex;
  flex-wrap: wrap;
  gap: 15px;
  margin-bottom: 20px;
  align-items: flex-end;
}

.filtro-grupo {
  display: flex;
  flex-direction: column;
}

.entregas-container {
  display: flex;
  flex-direction: column;
  gap: 15px;
}

.card-entrega {
  background-color: #fff;
  padding: 15px;
  border-radius: 6px;
  border: 1px solid #ccc;
  box-shadow: 1px 1px 4px rgba(0,0,0,0.05);
}

@media (max-width: 768px) {
  .filtros {
    flex-direction: column;
    align-items: stretch;
  }

  .filtro-grupo {
    width: 100%;
  }
}

  
  
    * { box-sizing: border-box; margin: 0; padding: 0; }

    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      margin: 0;
    }

    .sidebar {
      width: 220px;
      background-color: #2c3e50;
      height: 100vh;
      padding-top: 20px;
      position: fixed;
      left: 0;
      top: 0;
    }

    .sidebar a {
      display: block;
      color: #ecf0f1;
      padding: 15px 20px;
      text-decoration: none;
      transition: background 0.3s;
    }

    .sidebar a:hover {
      background-color: #34495e;
    }

    .sidebar i {
      margin-right: 10px;
    }

    .content {
      margin-left: 220px;
      padding: 30px;
    }

    .top-bar {
      margin-bottom: 20px;
    }

    .tela {
      display: none;
    }

    .entrega-disponivel {
      border: 1px solid #ccc;
      padding: 15px;
      margin: 10px 0;
      border-radius: 6px;
      background-color: #fff;
    }

    button {
      background-color: #28a745;
      color: white;
      padding: 10px 15px;
      border: none;
      border-radius: 4px;
      cursor: pointer;
      margin-top: 10px;
      width: 100%;
      font-size: 16px;
    }

    button:hover {
      background-color: #218838;
    }

    form {
      margin-bottom: 20px;
    }

    label, input {
      margin-right: 10px;
    }

    .perfil-box {
      background: #eef;
      padding: 20px;
      border-radius: 6px;
    }

    /* MOBILE */
    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        display: flex;
        flex-direction: row;
        padding: 0;
        overflow-x: auto;
      }

      .sidebar a {
        flex: 1;
        text-align: center;
        padding: 12px 10px;
        font-size: 14px;
        border-right: 1px solid #1c2833;
      }

      .content {
        margin-left: 0;
        padding: 15px;
      }

      .entrega-disponivel {
        font-size: 16px;
        padding: 20px;
      }

      button {
        font-size: 18px;
        padding: 14px;
      }
    }
  </style>
</head>
<body>
    
    

<div class="sidebar">
  <a href="#" id="link-entregas"><i class="bi bi-sign-turn-left"></i> Entregas</a>
 <a href="#" class="btn btn-outline-success" data-bs-toggle="modal" data-bs-target="#chatModal">
  <i class="bi bi-chat-dots"></i> Chat
</a>

  <a href="#" id="link-minhas"><i class="bi bi-card-checklist"></i> Minhas Entregas</a>
  <a href="#" id="link-editar-perfil"><i class="bi bi-person"></i> Perfil</a>
 <a href="logout.php" id="link-sair"><i class="bi bi-box-arrow-right"></i> Sair</a>

</div>

<div class="content">
  <div class="top-bar">
    <h2>Bem-vindo, <?= htmlspecialchars($usuario['nome']) ?>!</h2>
  </div>

  <!-- Entregas Disponíveis -->
  <div id="tela-entregas" class="tela">
    <h3>Entregas Disponíveis</h3>
    <div id="lista-entregas"></div>
  </div>

  
 <!-- Minhas Entregas -->
<div id="tela-minhas" class="tela">
  <h3>Minhas Entregas</h3>

  <!-- Filtros -->
    <h4 class="sec-title">Exportar em PDF</h4>
  <form action="exportar_entregas_pdf.php" method="GET" target="_blank" class="filtros">
    <div class="filtro-grupo">
      <label for="data_inicial">Data Inicial:</label>
      <input type="date" name="data_inicial" id="data_inicial" required class="input-filtro">
    </div>
    <div class="filtro-grupo">
      <label for="data_final">Data Final:</label>
      <input type="date" name="data_final" id="data_final" required class="input-filtro">
    </div>
    <button type="submit" class="btn btn-primary">Exportar PDF</button>
  </form>

  <div id="minhas-entregas" class="entregas-container"></div>


  
</div>
<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<style>
    /* Estilos gerais para modais */
.modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5); /* Fundo sombreado */
    z-index: 2000;
    overflow-y: auto;
    padding-top: 50px;
}

/* Modal Header */
.modal-header {
    display: flex;
    justify-content: space-between;
    padding: 16px;
    background-color: #128C7E;
    color: white;
    font-size: 18px;
    border-bottom: 1px solid #ccc;
}

.modal-header .btn-close {
    background: transparent;
    border: none;
    font-size: 24px;
    color: white;
    cursor: pointer;
}

.modal-header .btn-close:hover {
    color: #dcdcdc;
}

/* Modal Content */
.modal-content {
    background-color: #ffffff;
    border-radius: 8px;
    width: 100%;
    max-width: 400px;
    margin: 0 auto;
    overflow: hidden;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

/* Modal Body */
.modal-body {
    padding: 20px;
    overflow-y: auto;
    max-height: 400px; /* Limitar altura da área de mensagens */
    font-family: 'Arial', sans-serif;
}

#lista-conversas {
    max-height: 300px;
    overflow-y: auto;
}

#historico-conversa {
    max-height: 300px;
    overflow-y: auto;
}

.mensagem {
    padding: 8px;
    border-radius: 10px;
    margin-bottom: 10px;
    display: flex;
    flex-direction: column;
}

.mensagem-enviada {
    background-color: #DCF8C6;
    align-self: flex-end;
    text-align: right;
}

.mensagem-recebida {
    background-color: #FFFFFF;
    align-self: flex-start;
}

.nome-remetente {
    font-weight: bold;
    font-size: 12px;
    margin-bottom: 5px;
}

.conteudo-mensagem {
    font-size: 14px;
    word-wrap: break-word;
}

.data-envio {
    font-size: 10px;
    color: #555;
    margin-top: 5px;
}

/* Footer for modal - Enviar mensagem */
.modal-footer {
    display: flex;
    justify-content: space-between;
    padding: 10px;
    background-color: #f1f1f1;
    border-top: 1px solid #ccc;
}

.modal-footer input[type="text"] {
    width: 80%;
    padding: 8px;
    font-size: 14px;
    border: 1px solid #ccc;
    border-radius: 20px;
    outline: none;
}

.modal-footer input[type="text"]:focus {
    border-color: #128C7E;
}

.modal-footer button {
    background-color: #128C7E;
    color: white;
    padding: 8px 16px;
    border: none;
    border-radius: 20px;
    cursor: pointer;
    font-size: 14px;
}

.modal-footer button:hover {
    background-color: #075E54;
}

/* Botão para abrir nova conversa */
#nova-conversa-btn {
    background-color: #25D366;
    color: white;
    padding: 8px 16px;
    border: none;
    border-radius: 20px;
    display: block;
    text-align: center;
    margin: 10px auto;
    cursor: pointer;
}

#nova-conversa-btn:hover {
    background-color: #128C7E;
}

/* Modal para Nova Conversa - Ajustes */
#usuarioSelect {
    width: 100%;
    padding: 8px;
    font-size: 14px;
    border: 1px solid #ccc;
    border-radius: 8px;
    margin-bottom: 10px;
}

#novaMensagem {
    width: 100%;
    padding: 8px;
    font-size: 14px;
    border: 1px solid #ccc;
    border-radius: 8px;
    margin-bottom: 10px;
    resize: none;
}

</style>


<!-- Modal - Lista de Conversas -->
<div class="modal fade" id="chatModal" tabindex="-1" aria-labelledby="chatModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="chatModalLabel">Conversas</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <!-- Botão Nova Conversa -->
            <a href="#" id="nova-conversa-btn" class="btn btn-outline-success" data-bs-toggle="modal" data-bs-target="#novaConversaModal">
                Nova Conversa
            </a>
            <div class="modal-body" id="lista-conversas">
                <!-- A lista de conversas será carregada aqui via AJAX -->
            </div>
        </div>
    </div>
</div>



<!-- Modal - Conversa Específica -->
<div class="modal fade" id="conversaModal" tabindex="-1" aria-labelledby="conversaModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="conversaModalLabel">Histórico de Conversa</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="historico-conversa">
                <!-- O histórico da conversa será carregado aqui via AJAX -->
            </div>
            <div class="modal-footer">
                <input type="text" id="nova-mensagem" class="form-control" placeholder="Digite sua mensagem...">
                <button type="button" class="btn btn-primary" id="enviar-mensagem">Enviar</button>
            </div>
        </div>
    </div>
</div>




<!-- Modal - Nova Conversa -->
<div class="modal fade" id="novaConversaModal" tabindex="-1" aria-labelledby="novaConversaModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="novaConversaModalLabel">Iniciar Nova Conversa</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="usuarioSelect" class="form-label">Escolha o Usuário</label>
                    <select id="usuarioSelect" class="form-select">
                        <!-- Usuários serão carregados aqui via AJAX -->
                    </select>
                </div>
                <div class="mb-3">
                    <label for="novaMensagem" class="form-label">Sua Mensagem</label>
                    <textarea id="novaMensagem" class="form-control" rows="3"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="enviarNovaMensagem">Enviar</button>
            </div>
        </div>
    </div>
</div>

<script>
   document.addEventListener("DOMContentLoaded", function () {
    // Carregar os usuários para o select de nova conversa
    function carregarUsuarios() {
        fetch('chat/carregar_usuarios.php')
            .then(response => response.json())
            .then(data => {
                let usuarioSelect = document.getElementById('usuarioSelect');
                usuarioSelect.innerHTML = '<option value="" disabled selected>Escolha um usuário</option>';
                data.forEach(usuario => {
                    let option = document.createElement('option');
                    option.value = usuario.id;
                    option.textContent = usuario.nome;
                    usuarioSelect.appendChild(option);
                });
            });
    }

    // Obter o ID do usuário logado com segurança
    let usuario_id_logado = <?php echo isset($_SESSION['usuario']['id']) ? $_SESSION['usuario']['id'] : 'null'; ?>;  // Garantir que o ID do usuário logado seja passado

    // Verificar se o usuário logado existe
    if (usuario_id_logado === null) {
        console.error("Erro: ID do usuário logado não encontrado.");
        return;  // Impede a execução do código caso o ID do usuário logado não seja encontrado
    }

    // Enviar a nova conversa
    document.getElementById('enviarNovaMensagem').onclick = function () {
        let usuario_id = document.getElementById('usuarioSelect').value;
        let mensagem = document.getElementById('novaMensagem').value;

        // Verificar se ambos os campos estão preenchidos
        if (!usuario_id || !mensagem) {
            alert('Por favor, selecione um usuário e escreva uma mensagem.');
            return;
        }

        // Criar a conversa no banco
        fetch('chat/criar_conversa.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ 
                usuario_id_destino: usuario_id, 
                mensagem: mensagem, 
                usuario_id_logado: usuario_id_logado  // Passar o ID do usuário logado
            })  
        })
        .then(response => response.text())
        .then(data => {
            alert(data); // Exibir mensagem de sucesso
            // Fechar modal
            $('#novaConversaModal').modal('hide');
        });
    }

    carregarUsuarios();
});


document.addEventListener("DOMContentLoaded", function () {
    // Variável global para armazenar o ID da conversa
    let conversa_id_atual;

    // Carregar as conversas
    function carregarConversas() {
        fetch('chat/listar_conversas.php')
            .then(response => response.json())
            .then(data => {
                let listaConversas = document.getElementById('lista-conversas');
                listaConversas.innerHTML = '';  // Limpar a lista existente
                if (data.length > 0) {
                    data.forEach(conversa => {
                        let item = document.createElement('button');
                        item.classList.add('btn', 'btn-light', 'w-100', 'my-2');
                        item.textContent = conversa.usuario_comum + ' - ' + conversa.ultimo_mensagem;

                        // Passar o conversa_id para a função carregarHistorico
                        item.onclick = () => {
                            console.log('Conversa ID:', conversa.id);  // Verifique se o ID da conversa está correto
                            carregarHistorico(conversa.id);  // Passando o ID da conversa
                        };

                        listaConversas.appendChild(item);
                    });
                } else {
                    listaConversas.innerHTML = 'Você ainda não tem conversas.';
                }
            })
            .catch(error => {
                console.error("Erro ao carregar as conversas:", error);
            });
    }

    // Carregar o histórico da conversa
    function carregarHistorico(conversa_id) {
        conversa_id_atual = conversa_id;  // Armazena o ID da conversa globalmente
        fetch('chat/exibir_conversa.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ conversa_id: conversa_id })  // Passando o ID da conversa
        })
        .then(response => response.json())
        .then(data => {
            console.log("Mensagens carregadas:", data);  // Verificar as mensagens carregadas
            let historico = document.getElementById('historico-conversa');
            historico.innerHTML = '';  // Limpar o histórico anterior

            if (Array.isArray(data) && data.length > 0) {
                data.forEach(mensagem => {
                    let divMensagem = document.createElement('div');
                    divMensagem.classList.add('mensagem');

                    let isUsuarioLogado = mensagem.nome === 'Usuário Logado';  // Ajuste conforme seu critério

                    // Aplicar estilo baseado no remetente
                    divMensagem.classList.add(isUsuarioLogado ? 'mensagem-enviada' : 'mensagem-recebida');

                    divMensagem.innerHTML = `
                        <div class="nome-remetente">${mensagem.nome}</div>
                        <div class="conteudo-mensagem">${mensagem.mensagem}</div>
                        <div class="data-envio">${new Date(mensagem.data_envio).toLocaleString()}</div>
                    `;
                    historico.appendChild(divMensagem);
                });
            } else {
                historico.innerHTML = 'Nenhuma mensagem encontrada.';
            }

            $('#conversaModal').modal('show');
        })
        .catch(error => {
            console.error('Erro ao carregar o histórico da conversa:', error);
        });
    }

    // Enviar nova mensagem
    document.getElementById('enviar-mensagem').onclick = function () {
        let mensagem = document.getElementById('nova-mensagem').value;

        if (!mensagem) {
            alert('Digite uma mensagem.');
            return;
        }

        fetch('chat/enviar_mensagem.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                conversa_id: conversa_id_atual,  // Usa a variável global com o ID da conversa
                mensagem: mensagem
            })
        })
        .then(response => response.text())
        .then(data => {
            console.log(data);  // Log de depuração
            document.getElementById('nova-mensagem').value = '';  // Limpar o campo de mensagem
            carregarHistorico(conversa_id_atual); // Atualizar o histórico com a nova mensagem
        })
        .catch(error => {
            console.error('Erro ao enviar a mensagem:', error);
        });
    }

    // Carregar as conversas ao abrir a página
    carregarConversas();

    // Atualizar a lista de conversas a cada 5 segundos (5000ms)
    setInterval(carregarConversas, 5000);  // Adiciona o intervalo para atualização em tempo real
});

</script>





<style>
#tela-minhas {
  max-height: 80vh; /* Ajuste conforme necessário */
  overflow-y: auto;
  padding-right: 10px; /* espaço para barra */
  scrollbar-gutter: stable;
}

    
    .tela {
  max-width: 700px;
  margin: 0 auto;
  padding: 20px;
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  background: #fff;
  border-radius: 8px;
  box-shadow: 0 0 10px rgba(0,0,0,0.1);
}

h3 {
  margin-bottom: 20px;
  color: #333;
  font-weight: 600;
  border-bottom: 2px solid #007bff;
  padding-bottom: 8px;
}

.sec-title {
  margin-top: 40px;
  margin-bottom: 20px;
  color: #007bff;
  font-weight: 600;
  border-bottom: 1px solid #007bff;
  padding-bottom: 5px;
}

/* Layout desktop para filtros */
.filtros {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  margin-bottom: 25px;
  align-items: flex-end;
}

.filtro-grupo {
  display: flex;
  flex-direction: column;
  flex: 1 1 200px;
  min-width: 180px;
}

.filtro-grupo label {
  margin-bottom: 6px;
  font-weight: 500;
  color: #555;
}

.input-filtro {
  padding: 8px 12px;
  font-size: 1rem;
  border: 1.8px solid #ccc;
  border-radius: 6px;
  transition: border-color 0.3s ease;
}

.input-filtro:focus {
  border-color: #007bff;
  outline: none;
  box-shadow: 0 0 6px #cce5ff;
}

.btn {
  padding: 10px 24px;
  border: none;
  border-radius: 6px;
  font-weight: 600;
  cursor: pointer;
  transition: background-color 0.3s ease;
  color: #fff;
}

.btn-primary {
  background-color: #007bff;
}

.btn-primary:hover {
  background-color: #0056b3;
}

.entregas-container {
  min-height: 150px;
  border: 1px solid #ddd;
  border-radius: 6px;
  padding: 15px;
  background-color: #fafafa;
  color: #444;
  font-size: 1rem;
}

/* === Mobile Friendly Adjustments === */
@media (max-width: 480px) {
  .tela {
    padding: 15px 10px;
    max-width: 100%;
  }

  h3, .sec-title {
    font-size: 1.4rem;
  }

  .filtros {
    flex-direction: column;
    align-items: stretch;
  }

  .filtro-grupo {
    flex: none;
    width: 100%;
    margin-bottom: 15px;
  }

  .input-filtro {
    font-size: 1.1rem;
    padding: 10px 14px;
  }

  .btn {
    width: 100%;
    padding: 14px 0;
    font-size: 1.2rem;
  }

  .btn + .btn {
    margin-top: 10px;
  }

  .entregas-container {
    font-size: 1.1rem;
    padding: 12px;
  }
}

    
</style>


 <!-- Editar Perfil -->
<div id="tela-perfil" class="tela">
  <div class="perfil-box">
    <h3>Editar Perfil</h3>
    <form id="form-editar-perfil" novalidate>

      <div class="form-group">
        <label for="nome">Nome:</label>
        <input 
          type="text" 
          id="nome" 
          name="nome" 
          value="<?= htmlspecialchars($usuario['nome']) ?>" 
          required
        >
      </div>

      <div class="form-group">
        <label for="email">Email:</label>
        <input 
          type="email" 
          id="email" 
          name="email" 
          value="<?= htmlspecialchars($usuario['email']) ?>" 
          required 
        >
      </div>

      <div class="form-group">
        <label for="senha_atual">Senha Atual:</label>
        <input 
          type="password" 
          id="senha_atual" 
          name="senha_atual" 
          required 
        >
      </div>

      <div class="form-group">
        <label for="nova_senha">Nova Senha:</label>
        <input 
          type="password" 
          id="nova_senha" 
          name="nova_senha"
        >
      </div>

      <div class="form-group">
        <label for="confirma_senha">Confirmar Nova Senha:</label>
        <input 
          type="password" 
          id="confirma_senha" 
          name="confirma_senha"
        >
      </div>

      <div class="form-actions">
        <button type="submit" class="btn btn-primary">Salvar Alterações</button>
        <button type="button" id="btn-cancelar" class="btn btn-secondary">Cancelar</button>
      </div>
    </form>
    <div id="msg-resultado" class="msg-resultado"></div>
  </div>
</div>


<style>
  .perfil-box {
    background: #fff;
    padding: 20px 25px;
    border-radius: 8px;
    max-width: 400px;
    box-shadow: 0 2px 8px rgb(0 0 0 / 0.1);
    color: #333;
  }
  .perfil-box h3 {
    margin-bottom: 20px;
    font-weight: 700;
    font-size: 1.5rem;
    color: #2c3e50;
  }
  .form-group {
    margin-bottom: 15px;
    display: flex;
    flex-direction: column;
  }
  .form-group label {
    font-weight: 600;
    margin-bottom: 6px;
  }
  .form-group input {
    padding: 8px 10px;
    font-size: 1rem;
    border: 1px solid #ccc;
    border-radius: 5px;
    transition: border-color 0.3s ease;
  }
  .form-group input:focus {
    border-color: #2980b9;
    outline: none;
  }
  .form-actions {
    margin-top: 25px;
    display: flex;
    gap: 15px;
  }
  .btn {
    cursor: pointer;
    font-weight: 600;
    border-radius: 5px;
    padding: 10px 18px;
    border: none;
    transition: background-color 0.3s ease;
  }
  .btn-primary {
    background-color: #2980b9;
    color: white;
  }
  .btn-primary:hover {
    background-color: #1f6391;
  }
  .btn-secondary {
    background-color: #bdc3c7;
    color: #2c3e50;
  }
  .btn-secondary:hover {
    background-color: #95a5a6;
  }
  .msg-resultado {
    margin-top: 15px;
    min-height: 20px;
    font-weight: 600;
    color: #27ae60; /* verde para sucesso, pode alterar dinamicamente */
  }
</style>


<script>
function mostrarTela(id) {
  $('.tela').hide();
  $('#' + id).show();
}





// Menu lateral
$('.sidebar a').click(function(e) {
  const link = $(this).attr('id');

  if (link === 'link-sair') {
    // Permite o comportamento normal do link "Sair"
    return;
  }

  e.preventDefault();

  if (link === 'link-editar-perfil') {
    mostrarTela('tela-perfil');
    $('#msg-resultado').html('');
  } else if (link === 'link-entregas') {
    mostrarTela('tela-entregas');
  } else if (link === 'link-minhas') {
    mostrarTela('tela-minhas');
  }
});


function carregarEntregasDisponiveis() {
  $.getJSON('buscar_entregas.php', function(entregas) {
    let html = '';
    entregas.forEach(function(e) {
      // Formata o horário se 'e.disponivel_em' vier como uma string completa de data/hora
      let horarioExibicao = '';
      if (e.disponivel_em) {
        // Converte para objeto Date e formata para HH:mm (exibindo apenas minutos diretamente)
        const minutos = e.disponivel_em;
        horarioExibicao = `${minutos} minutos`;
      } else if (e.horario_formatado) {
        // Se o PHP já formatou, use diretamente
        horarioExibicao = e.horario_formatado;
      }

      html += `<div class="entrega-disponivel">
        <b>Destino:</b> ${e.destino}<br>
        <b>Restaurante:</b> ${e.restaurante}<br>
        <b>Taxa:</b> R$ ${Number(e.taxa).toFixed(2).replace('.', ',')}<br>
        <b>Bairro:</b> ${e.nome_bairro}<br>`;  // Adicionando o nome do bairro

      // Adiciona a linha do horário apenas se houver um horário para exibir
      if (horarioExibicao) {
        html += `<b>Disponível em:</b> ${horarioExibicao}<br>`;
      }

      html += `<button onclick="aceitarEntrega(${e.id})">Aceitar Entrega</button>
      </div>`;
    });
    $('#lista-entregas').html(html);
  });
}


function aceitarEntrega(id) {
  $.post('aceitar_entrega.php', { id: id }, function(resp) {
    if (resp.toLowerCase().includes("sucesso")) {
      Swal.fire({
        icon: 'success',
        title: 'Entrega aceita!',
        text: resp,
        timer: 2000,
        showConfirmButton: false,
        didOpen: () => {
          document.querySelector(".swal2-container").style.zIndex = "20000"; // sempre acima
        }
      });

      setTimeout(() => {
        carregarEntregasDisponiveis();
        carregarMinhasEntregas();
      }, 2000);

    } else {
      Swal.fire({
        icon: 'error',
        title: 'Erro',
        text: resp,
        timer: 2500,
        showConfirmButton: false,
        didOpen: () => {
          document.querySelector(".swal2-container").style.zIndex = "20000";
        }
      });
    }
  });
}

function carregarMinhasEntregas(filtros = {}) {
  $.get('filtrar_entregas_motoboy.php', filtros, function(html) {
    $('#minhas-entregas').html(html);
  });
}

$(document).on('click', '.btn-cancelar-entrega', function() {
  var entregaId = $(this).data('id');

  Swal.fire({
    title: 'Cancelar entrega?',
    text: "Tem certeza que deseja cancelar esta entrega?",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sim, cancelar',
    cancelButtonText: 'Não',
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      $.post('cancelar_entrega.php', { entrega_id: entregaId }, function(response) {
        if (response.success) {
          Swal.fire({
            icon: 'success',
            title: 'Entrega cancelada!',
            text: response.message,
            timer: 2000,
            showConfirmButton: false,
            didOpen: () => {
              document.querySelector(".swal2-container").style.zIndex = "20000";
            }
          });

          setTimeout(() => {
            carregarMinhasEntregas();
          }, 2000);

        } else {
          Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: response.message,
            timer: 2500,
            showConfirmButton: false,
            didOpen: () => {
              document.querySelector(".swal2-container").style.zIndex = "20000";
            }
          });
        }
      }, 'json');
    }
  });
});


$('#form-filtro').on('submit', function(e) {
  e.preventDefault();
  const filtros = {
    data: $(this).find('[name="data"]').val(),
    restaurante: $(this).find('[name="restaurante"]').val()
  };
  carregarMinhasEntregas(filtros);
});

$('#btn-cancelar').click(function() {
  mostrarTela('tela-entregas');
  $('#msg-resultado').html('');
  $('#form-editar-perfil')[0].reset();
});

$('#form-editar-perfil').submit(function(e) {
  e.preventDefault();
  const formData = $(this).serialize();
  $.post('editar_perfil_motoboy.php', formData, function(resp) {
    $('#msg-resultado').html(resp);
    if (resp.includes('sucesso')) {
      $('#form-editar-perfil')[0].reset();
      setTimeout(() => mostrarTela('tela-entregas'), 2000);
    }
  });
});

// Inicialização
$(document).ready(function() {
  carregarEntregasDisponiveis();
  carregarMinhasEntregas();
  mostrarTela('tela-entregas');
  setInterval(carregarEntregasDisponiveis, 5000);
});
</script>







</body>


</html>
