<?php
// listar_estabelecimentos.php
require_once 'conexao.php';

header('Content-Type: application/json');

try {
    $sql = "SELECT id, nome FROM usuarios WHERE tipo = 'restaurante' ORDER BY nome";
    $stmt = $pdo->query($sql);
    $restaurantes = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['status' => 'success', 'data' => $restaurantes]);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'msg' => 'Erro ao listar estabelecimentos: ' . $e->getMessage()]);
}
