<?php
include 'autentica.php';
include 'conexao.php';

if ($usuario['tipo'] != 'admin') {
  http_response_code(403);
  exit('Acesso negado');
}

$restaurante_id = $_GET['restaurante_id'] ?? '';
$motoboy_id = $_GET['motoboy_id'] ?? '';
$data_inicio = $_GET['data_inicio'] ?? '';
$data_fim = $_GET['data_fim'] ?? '';

$query = "
  SELECT e.*, 
    r.nome AS restaurante_nome,
    m.nome AS motoboy_nome
  FROM entregas e
  LEFT JOIN usuarios r ON e.restaurante_id = r.id
  LEFT JOIN usuarios m ON e.motoboy_id = m.id
  WHERE 1=1
";

$params = [];

if ($restaurante_id !== '') {
  $query .= " AND e.restaurante_id = ? ";
  $params[] = $restaurante_id;
}

if ($motoboy_id !== '') {
  $query .= " AND e.motoboy_id = ? ";
  $params[] = $motoboy_id;
}

if ($data_inicio !== '') {
  $query .= " AND e.criado_em >= ? ";
  $params[] = $data_inicio . ' 00:00:00';
}

if ($data_fim !== '') {
  $query .= " AND e.criado_em <= ? ";
  $params[] = $data_fim . ' 23:59:59';
}

$query .= " ORDER BY e.criado_em DESC";

$sql = $pdo->prepare($query);
$sql->execute($params);
$dados = $sql->fetchAll(PDO::FETCH_ASSOC);

$entregas = [];

foreach ($dados as $linha) {
  $valor_total = floatval($linha['valor_total'] ?? 0);
  $taxa = floatval($linha['taxa'] ?? 0);
  $linha['valor_liquido'] = $valor_total - $taxa;
  $entregas[] = $linha;
}

header('Content-Type: application/json');
echo json_encode($entregas);
