<?php
include 'autentica.php';
include 'conexao.php';

if ($usuario['tipo'] != 'motoboy') exit('Acesso negado');

$condicoes = ["e.motoboy_id = :motoboy_id"];
$params = [':motoboy_id' => $usuario['id']];

if (!empty($_GET['data'])) {
  $condicoes[] = "DATE(e.criado_em) = :data";
  $params[':data'] = $_GET['data'];
}

if (!empty($_GET['restaurante'])) {
  $condicoes[] = "u.nome LIKE :restaurante";
  $params[':restaurante'] = "%{$_GET['restaurante']}%";
}

$sql = $pdo->prepare("
  SELECT e.*, u.nome AS restaurante_nome
  FROM entregas e
  JOIN usuarios u ON e.restaurante_id = u.id
  WHERE " . implode(' AND ', $condicoes) . "
  ORDER BY e.criado_em DESC
");
$sql->execute($params);
$entregas = $sql->fetchAll();

// Encontrar o ID da última entrega aceita (status = 'aceita')
$ultima_aceita_id = null;
foreach ($entregas as $entrega) {
  if (strtolower($entrega['status']) === 'aceita') {
    $ultima_aceita_id = $entrega['id'];
    break; // primeira na lista (ordenada desc) é a última aceita
  }
}




echo "<div class='container-entregas'>";
foreach ($entregas as $e) {
  $status_lower = strtolower($e['status']);
  echo "<div class='card-entrega'>
    <div class='card-header'>
      <strong>{$e['restaurante_nome']}</strong>
      <span class='status {$status_lower}'>{$e['status']}</span>
    </div>
    <div class='card-body'>
      <p><b>Destino:</b> {$e['destino']}</p>
      <p><b>Taxa:</b> R$ " . number_format($e['taxa'], 2, ',', '.') . "</p>
      <p><b>Valor Líquido:</b> R$ " . number_format($e['valor_liquido'], 2, ',', '.') . "</p>
      <p><b>Data:</b> " . date('d/m/Y H:i', strtotime($e['criado_em'])) . "</p>";
  
  // Botão cancelar só se status aceita E for a última aceita
  if ($status_lower === 'aceita' && $e['id'] == $ultima_aceita_id) {
    echo "<button class='btn-cancelar-entrega' data-id='{$e['id']}'>Cancelar Entrega</button>";
  }
  
  echo "</div></div>";
}
echo "</div>";
?>

<style>
.container-entregas {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  margin-top: 20px;
}

.card-entrega {
  background: #fff;
  border: 1px solid #ddd;
  border-radius: 12px;
  padding: 16px;
  box-shadow: 0 2px 6px rgba(0,0,0,0.08);
  width: 100%;
  max-width: 400px;
  transition: transform 0.2s ease;
  position: relative;
}

.card-entrega:hover {
  transform: scale(1.02);
}

.card-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  font-size: 1.1em;
  margin-bottom: 10px;
  border-bottom: 1px solid #eee;
  padding-bottom: 5px;
}

.card-body p {
  margin: 6px 0;
}

.status {
  padding: 4px 8px;
  border-radius: 6px;
  font-size: 0.85em;
  color: white;
  text-transform: capitalize;
}

.status.pendente { background: #f39c12; }
.status.pago     { background: #27ae60; }
.status.cancelado { background: #c0392b; }
.status.aceita   { background: #2980b9; }

.btn-cancelar-entrega {
  margin-top: 10px;
  padding: 6px 10px;
  background-color: #e74c3c;
  border: none;
  color: white;
  border-radius: 6px;
  cursor: pointer;
  transition: background-color 0.2s ease;
}

.btn-cancelar-entrega:hover {
  background-color: #c0392b;
}
</style>
