<?php
// PDF MOTOBOY
include 'autentica.php';
include 'conexao.php';
require_once 'dompdf/autoload.inc.php';

use Dompdf\Dompdf;

if ($usuario['tipo'] != 'motoboy') exit('Acesso negado');

$data_inicial = $_GET['data_inicial'] ?? '';
$data_final = $_GET['data_final'] ?? '';

if (!$data_inicial || !$data_final) {
  exit('Datas inválidas');
}

$sql = $pdo->prepare("
  SELECT e.*, u.nome AS restaurante_nome
  FROM entregas e
  JOIN usuarios u ON e.restaurante_id = u.id
  WHERE e.motoboy_id = ? 
    AND DATE(e.criado_em) BETWEEN ? AND ?
  ORDER BY e.criado_em DESC
");
$sql->execute([$usuario['id'], $data_inicial, $data_final]);
$entregas = $sql->fetchAll();

// ESTILO CSS PARA O PDF
$css = "
  <style>
    body { font-family: DejaVu Sans, sans-serif; color:#333; font-size:12px; }
    h2 { text-align:center; margin-bottom:5px; color:#444; }
    p { text-align:center; margin:0 0 15px 0; font-size:11px; }
    table { width:100%; border-collapse:collapse; margin-top:10px; }
    th, td { border:1px solid #ccc; padding:8px; }
    th { background:#f7f7f7; font-weight:bold; text-align:center; }
    tr:nth-child(even) { background:#fafafa; }
    .total { font-weight:bold; background:#f0f0f0; }
    .total td { text-align:right; }
  </style>
";

$html = $css;
$html .= "<h2>Relatório de Entregas - {$usuario['nome']}</h2>";
$html .= "<p>Período: " . date('d/m/Y', strtotime($data_inicial)) . " até " . date('d/m/Y', strtotime($data_final)) . "</p>";

if (!$entregas) {
  $html .= "<p>Nenhuma entrega encontrada nesse período.</p>";
} else {
  $html .= "<table>
    <tr>
      <th>Data</th>
      <th>Destino</th>
      <th>Restaurante</th>
      <th>Status</th>
      <th>Taxa</th>
      <th>Valor Líquido</th>
    </tr>";

  $totalLiquido = 0;

  foreach ($entregas as $e) {
    $taxaFormatada = number_format($e['taxa'], 2, ',', '.');
    $valorLiquidoFormatado = number_format($e['valor_liquido'], 2, ',', '.');
    $totalLiquido += $e['valor_liquido'];

    $html .= "<tr>
      <td>" . date('d/m/Y H:i', strtotime($e['criado_em'])) . "</td>
      <td>" . htmlspecialchars($e['destino']) . "</td>
      <td>" . htmlspecialchars($e['restaurante_nome']) . "</td>
      <td>" . htmlspecialchars($e['status']) . "</td>
      <td>R$ {$taxaFormatada}</td>
      <td>R$ {$valorLiquidoFormatado}</td>
    </tr>";
  }

  $html .= "<tr class='total'>
    <td colspan='5'>Total Líquido:</td>
    <td>R$ " . number_format($totalLiquido, 2, ',', '.') . "</td>
  </tr>";

  $html .= "</table>";
}

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("entregas_motoboy.pdf", ["Attachment" => true]);
