<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['usuario']) || $_SESSION['usuario']['tipo'] !== 'admin') {
  http_response_code(403);
  exit('Acesso negado');
}

$sql = $pdo->query("SELECT id, nome, status FROM usuarios WHERE nome <> 'Admin' ORDER BY nome");
$usuarios = $sql->fetchAll();

if (!$usuarios) {
  echo "<p>Nenhum usuário encontrado.</p>";
  exit;
}

echo '<table class="table table-striped">';
echo '<thead><tr><th>Nome</th><th>Status</th></tr></thead><tbody>';

foreach ($usuarios as $usuario) {
  echo '<tr>';
  echo '<td>' . htmlspecialchars($usuario['nome']) . '</td>';
  echo '<td>
          <select class="form-select select-status-usuario" data-usuario-id="' . $usuario['id'] . '">
            <option value="ATIVO" ' . ($usuario['status'] === 'ATIVO' ? 'selected' : '') . '>ATIVO</option>
            <option value="INATIVO" ' . ($usuario['status'] === 'INATIVO' ? 'selected' : '') . '>INATIVO</option>
          </select>
        </td>';
  echo '</tr>';
}
echo '</tbody></table>';
?>
