<?php
include $_SERVER['DOCUMENT_ROOT'].'/conexao.php';
session_start();

// Receber os dados JSON enviados pelo frontend
$data = json_decode(file_get_contents('php://input'), true);

// Obter os dados
$user_id = $_SESSION['usuario']['id'];  // ID do usuário logado
$conversa_id = isset($data['conversa_id']) ? $data['conversa_id'] : null;
$mensagem = isset($data['mensagem']) ? $data['mensagem'] : '';

// Verificar se os dados foram fornecidos
if (empty($conversa_id) || empty($mensagem)) {
    echo 'Erro: Dados incompletos para enviar a mensagem.';
    exit;
}

// Inserir a nova mensagem
$sql = "INSERT INTO mensagens (id_conversa, id_remetente, mensagem, data_envio) 
        VALUES (:conversa_id, :user_id, :mensagem, NOW())";

$stmt = $pdo->prepare($sql);
$stmt->bindParam(':conversa_id', $conversa_id, PDO::PARAM_INT);
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
$stmt->bindParam(':mensagem', $mensagem, PDO::PARAM_STR);
$stmt->execute();

// Atualizar a última mensagem na tabela de conversas
$sql_update = "UPDATE conversas SET ultimo_mensagem = NOW() WHERE id = :conversa_id";
$stmt_update = $pdo->prepare($sql_update);
$stmt_update->bindParam(':conversa_id', $conversa_id, PDO::PARAM_INT);
$stmt_update->execute();

echo 'Mensagem enviada com sucesso!';
