<?php
session_start();
require 'conexao.php';

$motoboy_id = $_SESSION['usuario']['id'] ?? null;
$entrega_id = $_POST['entrega_id'] ?? null;

if (!$motoboy_id || !$entrega_id) {
    echo json_encode(['success' => false, 'message' => 'Dados insuficientes']);
    exit;
}

// Verificar se a entrega pertence ao motoboy e está ACEITA
$sql = $pdo->prepare("SELECT * FROM entregas WHERE id = :id AND motoboy_id = :motoboy_id AND status = 'ACEITA'");
$sql->execute([':id' => $entrega_id, ':motoboy_id' => $motoboy_id]);
$entrega = $sql->fetch();

if (!$entrega) {
    echo json_encode(['success' => false, 'message' => 'Entrega não encontrada ou status inválido']);
    exit;
}

// Verificar se é a última entrega aceita pelo motoboy
$sql = $pdo->prepare("SELECT id FROM entregas WHERE motoboy_id = :motoboy_id AND status = 'ACEITA' ORDER BY criado_em DESC LIMIT 1");
$sql->execute([':motoboy_id' => $motoboy_id]);
$ultima = $sql->fetch();

if (!$ultima || $ultima['id'] != $entrega_id) {
    echo json_encode(['success' => false, 'message' => 'Só pode cancelar a última entrega aceita']);
    exit;
}




// Cancelar a entrega: status volta para pendente e motoboy_id é removido
$sql = $pdo->prepare("UPDATE entregas SET status = 'pendente', motoboy_id = NULL, aceita_em = NULL WHERE id = :id");
$sql->execute([':id' => $entrega_id]);

echo json_encode(['success' => true, 'message' => 'Entrega cancelada com sucesso e disponibilizada novamente']);
?>
