<?php
// buscar_entregas.php
include 'conexao.php';

try {
    $sql = $pdo->query("
        SELECT e.*, u.nome AS restaurante, b.nome_bairro
        FROM entregas e
        JOIN usuarios u ON e.restaurante_id = u.id
        LEFT JOIN bairros_taxas b ON e.bairro_id = b.id  -- Adicionando o nome do bairro
        WHERE e.motoboy_id IS NULL
    ");
    $dados = $sql->fetchAll(PDO::FETCH_ASSOC);

    // Itera sobre os resultados para formatar o horário
    foreach ($dados as &$entrega) { // Usamos '&' para modificar o array original
        if (isset($entrega['disponivel_em'])) {
            // Converte minutos para exibir os minutos diretamente
            $minutos = (int)$entrega['disponivel_em'];

            // Formata os minutos
            $entrega['horario_formatado'] = $minutos . ' minutos';
        } else {
            $entrega['horario_formatado'] = 'N/A'; // Ou vazio, conforme preferir
        }
    }

    header('Content-Type: application/json');
    echo json_encode($dados);

} catch (PDOException $e) {
    // Trata erros de conexão ou consulta ao banco de dados
    header('HTTP/1.1 500 Internal Server Error');
    echo json_encode(['error' => 'Erro ao buscar entregas: ' . $e->getMessage()]);
} catch (Exception $e) {
    // Trata outros erros, como problemas com a formatação
    header('HTTP/1.1 500 Internal Server Error');
    echo json_encode(['error' => 'Erro de processamento: ' . $e->getMessage()]);
}
?>
