let deferredPrompt;
const installBtn = document.getElementById('installBtn');

// Detecta o evento `beforeinstallprompt`
window.addEventListener('beforeinstallprompt', (e) => {
  // Previne que o navegador mostre o prompt de instalação automaticamente
  e.preventDefault();
  deferredPrompt = e;
  
  // Torna o botão de instalação visível
  installBtn.style.display = 'block';

  installBtn.addEventListener('click', () => {
    // Mostra o prompt de instalação quando o botão for clicado
    deferredPrompt.prompt();

    // Aguarda a resposta do usuário
    deferredPrompt.userChoice.then((choiceResult) => {
      if (choiceResult.outcome === 'accepted') {
        console.log('Usuário aceitou a instalação do PWA');
      } else {
        console.log('Usuário recusou a instalação do PWA');
      }
      deferredPrompt = null;
      installBtn.style.display = 'none'; // Esconde o botão após a resposta
    });
  });
});

// Se o PWA já estiver instalado, esconde o botão
if (window.matchMedia('(display-mode: standalone)').matches) {
  installBtn.style.display = 'none';
}

// Verificar se o navegador suporta Service Workers
if ('serviceWorker' in navigator) {
  window.addEventListener('load', () => {
    navigator.serviceWorker.register('/service-worker.js')
      .then(registration => {
        console.log('Service Worker registrado com sucesso:', registration);
      })
      .catch(error => {
        console.log('Falha ao registrar o Service Worker:', error);
      });
  });
}
