<?php
require_once 'dompdf/autoload.inc.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

use Dompdf\Dompdf;

include 'autentica.php';
include 'conexao.php';

$restaurante_id = $_GET['restaurante_id'] ?? '';
$motoboy_id = $_GET['motoboy_id'] ?? '';
$data_inicio = isset($_GET['data_inicio']) && $_GET['data_inicio'] !== 'undefined' ? $_GET['data_inicio'] : null;
$data_fim = isset($_GET['data_fim']) && $_GET['data_fim'] !== 'undefined' ? $_GET['data_fim'] : null;

function is_valid_date($date) {
    if (!$date || !is_string($date)) return false;
    $d = DateTime::createFromFormat('Y-m-d', $date);
    return $d && $d->format('Y-m-d') === $date;
}

// Monta a query com filtros
$query = "
  SELECT e.*, 
    r.nome AS restaurante_nome,
    m.nome AS motoboy_nome
  FROM entregas e
  LEFT JOIN usuarios r ON e.restaurante_id = r.id
  LEFT JOIN usuarios m ON e.motoboy_id = m.id
  WHERE 1=1
";

$params = [];

if ($restaurante_id !== '') {
  $query .= " AND e.restaurante_id = ? ";
  $params[] = $restaurante_id;
}

if ($motoboy_id !== '') {
  $query .= " AND e.motoboy_id = ? ";
  $params[] = $motoboy_id;
}

if (is_valid_date($data_inicio) && is_valid_date($data_fim)) {
  $query .= " AND DATE(e.criado_em) BETWEEN ? AND ? ";
  $params[] = $data_inicio;
  $params[] = $data_fim;
}

$query .= " ORDER BY e.criado_em DESC";

$sql = $pdo->prepare($query);
$sql->execute($params);
$entregas = $sql->fetchAll(PDO::FETCH_ASSOC);

// Começa o HTML do relatório com estilo melhorado
$html = '
<style>
  body {
    font-family: Arial, sans-serif;
    font-size: 12px;
    color: #333;
  }

  h2 {
    text-align: center;
    color: #2c3e50;
    margin-bottom: 20px;
  }

  table {
    width: 100%;
    border-collapse: collapse;
    margin: 0 auto;
  }

  th, td {
    border: 1px solid #ccc;
    padding: 8px 10px;
    text-align: left;
  }

  th {
    background-color: #f8f9fa;
    color: #333;
    font-weight: bold;
  }

  tr:nth-child(even) {
    background-color: #f2f2f2;
  }

  tr:hover {
    background-color: #e0f7fa;
  }

  tfoot td {
    font-weight: bold;
    background-color: #eaf2f8;
  }
</style>

<h2>Relatório de Entregas</h2>
<table>
  <thead>
    <tr>
      <th>ID</th>
      <th>Destino</th>
      <th>Status</th>
      <th>Restaurante</th>
      <th>Motoboy</th>
      <th>Data</th>
      <th>Taxa</th>
      <th>Valor Líquido</th>
    </tr>
  </thead>
  <tbody>';

$totalLiquido = 0;
foreach ($entregas as $e) {
  $taxa = (float)$e['taxa'];
  $liquido = $taxa - 2;
  $totalLiquido += $liquido;

  $html .= "<tr>
    <td>{$e['id']}</td>
    <td>{$e['destino']}</td>
    <td>{$e['status']}</td>
    <td>{$e['restaurante_nome']}</td>
    <td>{$e['motoboy_nome']}</td>
    <td>" . date('d/m/Y H:i', strtotime($e['criado_em'])) . "</td>
    <td>R$ " . number_format($taxa, 2, ',', '.') . "</td>
    <td>R$ " . number_format($liquido, 2, ',', '.') . "</td>
  </tr>";
}

$html .= '</tbody>
  <tfoot>
    <tr>
      <td colspan="7">Total Líquido</td>
      <td>R$ ' . number_format($totalLiquido, 2, ',', '.') . '</td>
    </tr>
  </tfoot>
</table>';

// Gera o PDF
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'landscape');
$dompdf->render();
$dompdf->stream("relatorio_entregas.pdf", ["Attachment" => false]);
exit;
?>
