<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/conexao.php'; // Caminho fixo para a conexão

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['id'])) {
    // Pegando os dados enviados do formulário
    $id = $_POST['id'];
    $nome = $_POST['nome'];
    $email = $_POST['email'];
    $tipo = $_POST['tipo'];
    $status = $_POST['status'];
    $senha = $_POST['senha'];
    $confirmar_senha = $_POST['confirmar_senha'];

    // Verificar se a senha foi fornecida e se as senhas coincidem
    if (!empty($senha)) {
        if ($senha !== $confirmar_senha) {
            echo json_encode(["error" => "As senhas não coincidem"]);
            exit;
        }

        // Gerar um hash da nova senha
        $senhaHash = password_hash($senha, PASSWORD_BCRYPT);
    } else {
        // Caso a senha não tenha sido fornecida, manter a senha atual
        $senhaHash = null;
    }

    try {
        // Atualizar os dados do usuário
        if ($senhaHash) {
            // Se a senha foi fornecida, atualizar a senha também
            $sql = "UPDATE usuarios SET nome = :nome, email = :email, tipo = :tipo, status = :status, senha = :senha WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':senha', $senhaHash, PDO::PARAM_STR);
        } else {
            // Caso contrário, atualizar sem mexer na senha
            $sql = "UPDATE usuarios SET nome = :nome, email = :email, tipo = :tipo, status = :status WHERE id = :id";
            $stmt = $pdo->prepare($sql);
        }

        // Bind dos parâmetros
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->bindParam(':nome', $nome, PDO::PARAM_STR);
        $stmt->bindParam(':email', $email, PDO::PARAM_STR);
        $stmt->bindParam(':tipo', $tipo, PDO::PARAM_STR);
        $stmt->bindParam(':status', $status, PDO::PARAM_STR);

        // Executar a atualização
        if ($stmt->execute()) {
            echo json_encode(["success" => "Usuário atualizado com sucesso"]);
        } else {
            echo json_encode(["error" => "Erro ao atualizar o usuário"]);
        }
    } catch (PDOException $e) {
        echo json_encode(["error" => "Erro na consulta: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["error" => "Dados inválidos"]);
}
?>
